/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.data.Attribute;
import smile.feature.FeatureTransform;
import smile.math.Math;

public class Standardizer
extends FeatureTransform {
    double[] mu;
    double[] std;

    public Standardizer() {
    }

    public Standardizer(boolean copy) {
        super(copy);
    }

    @Override
    public void learn(Attribute[] attributes, double[][] data) {
        this.mu = Math.colMeans(data);
        this.std = Math.colSds(data);
        for (int i = 0; i < this.std.length; ++i) {
            if (attributes[i].getType() != Attribute.Type.NUMERIC) {
                this.mu[i] = Double.NaN;
            }
            if (!Math.isZero(this.std[i])) continue;
            this.std[i] = 1.0;
        }
    }

    @Override
    public double[] transform(double[] x) {
        if (x.length != this.mu.length) {
            throw new IllegalArgumentException(String.format("Invalid vector size %d, expected %d", x.length, this.mu.length));
        }
        double[] y = this.copy ? new double[x.length] : x;
        for (int i = 0; i < x.length; ++i) {
            y[i] = !Double.isNaN(this.mu[i]) ? (x[i] - this.mu[i]) / this.std[i] : x[i];
        }
        return y;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Standardizer(");
        if (this.mu != null) {
            sb.append("\n");
            for (int i = 0; i < this.mu.length; ++i) {
                sb.append(String.format("  [%.4f, %.4f]%n", this.mu[i], this.std[i]));
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

