/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.vq;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import smile.demo.vq.VQDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;
import smile.vq.GrowingNeuralGas;

public class GrowingNeuralGasDemo
extends VQDemo {
    @Override
    public JComponent learn() {
        long clock = System.currentTimeMillis();
        GrowingNeuralGas gas = new GrowingNeuralGas(2, 0.05, 6.0E-4, 88, 200, 0.5, 0.9995);
        for (int loop = 0; loop < 25; ++loop) {
            for (double[] x : dataset[datasetIndex]) {
                gas.update(x);
            }
        }
        gas.partition(clusterNumber);
        System.out.format("Growing Neural Gas clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        int[] membership = new int[dataset[datasetIndex].length];
        int[] clusterSize = new int[clusterNumber];
        for (int i = 0; i < dataset[datasetIndex].length; ++i) {
            membership[i] = gas.predict(dataset[datasetIndex][i]);
            int n = membership[i];
            clusterSize[n] = clusterSize[n] + 1;
        }
        GrowingNeuralGas.Neuron[] neurons = gas.neurons();
        double[][] x = new double[neurons.length][];
        for (int i = 0; i < x.length; ++i) {
            x[i] = neurons[i].w;
        }
        PlotCanvas plot = ScatterPlot.plot((double[][])x, '@');
        for (int k = 0; k < clusterNumber; ++k) {
            if (clusterSize[k] <= 0) continue;
            double[][] cluster = new double[clusterSize[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (membership[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        for (int i = 0; i < neurons.length; ++i) {
            for (int j = 0; j < neurons[i].neighbors.length; ++j) {
                plot.line((double[][])new double[][]{neurons[i].w, neurons[i].neighbors[j].w});
            }
        }
        plot.points((double[][])x, '@');
        return plot;
    }

    @Override
    public String toString() {
        return "Growing Neural Gas";
    }

    public static void main(String[] argv) {
        GrowingNeuralGasDemo demo = new GrowingNeuralGasDemo();
        JFrame f = new JFrame("Growing Neural Gas");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

