/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.math.Math;
import smile.plot.Histogram;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.GaussianDistribution;
import smile.stat.distribution.GaussianMixture;

public class GaussianMixtureDemo
extends JPanel {
    public GaussianMixtureDemo() {
        super(new GridLayout(2, 2));
        int i;
        double[] data = new double[]{23.0, 23.0, 22.0, 22.0, 21.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 24.0, 22.0, 22.0, 16.0, 16.0, 16.0, 23.0, 23.0, 15.0, 21.0, 21.0, 21.0, 21.0, 24.0, 24.0, 21.0, 21.0, 24.0, 24.0, 24.0, 24.0, 1.0, 1.0, 23.0, 23.0, 22.0, 22.0, 14.0, 24.0, 24.0, 23.0, 23.0, 18.0, 18.0, 23.0, 23.0, 24.0, 24.0, 22.0, 22.0, 17.0, 17.0, 17.0, 21.0, 21.0, 15.0, 14.0};
        GaussianMixture mixture = new GaussianMixture(data);
        PlotCanvas canvas = Histogram.plot(data, 24);
        canvas.setTitle("Gaussian Mixture with Singular Component");
        this.add(canvas);
        double width = (Math.max(data) - Math.min(data)) / 24.0;
        double[][] p = new double[50][2];
        for (int i2 = 0; i2 < p.length; ++i2) {
            p[i2][0] = (double)i2 * 0.5;
            p[i2][1] = mixture.p(p[i2][0]) * width;
        }
        canvas.line(p, Color.RED);
        canvas = QQPlot.plot(data, mixture);
        canvas.setTitle("Q-Q Plot");
        this.add(canvas);
        data = new double[3000];
        GaussianDistribution g1 = new GaussianDistribution(1.0, 1.0);
        for (int i3 = 0; i3 < 500; ++i3) {
            data[i3] = g1.rand();
        }
        GaussianDistribution g2 = new GaussianDistribution(4.0, 1.0);
        for (int i4 = 500; i4 < 1000; ++i4) {
            data[i4] = g2.rand();
        }
        GaussianDistribution g3 = new GaussianDistribution(8.0, 1.0);
        for (int i5 = 1000; i5 < 2000; ++i5) {
            data[i5] = g3.rand();
        }
        GaussianDistribution g4 = new GaussianDistribution(-3.0, 1.0);
        for (int i6 = 2000; i6 < 2500; ++i6) {
            data[i6] = g4.rand();
        }
        GaussianDistribution g5 = new GaussianDistribution(-6.0, 1.0);
        for (i = 2500; i < 3000; ++i) {
            data[i] = g5.rand();
        }
        mixture = new GaussianMixture(data, 5);
        canvas = Histogram.plot(data, 50);
        canvas.setTitle("Gaussian Mixture of Five Components");
        this.add(canvas);
        width = (Math.max(data) - Math.min(data)) / 50.0;
        p = new double[220][2];
        for (i = 0; i < p.length; ++i) {
            p[i][0] = -10.0 + (double)i * 0.1;
            p[i][1] = mixture.p(p[i][0]) * width;
        }
        canvas.line(p, Color.RED);
        canvas = QQPlot.plot(data, mixture);
        canvas.setTitle("Q-Q Plot");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Gaussian Mixture";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Gaussian Mixture");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new GaussianMixtureDemo());
        frame.setVisible(true);
    }
}

