/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.math.Math;
import smile.plot.Histogram;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.GaussianDistribution;

public class GaussianDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private PlotCanvas qqplot;
    private JSlider sigmaSlider;
    private double sigma = 1.0;

    public GaussianDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 50; i += 10) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf(i / 10)));
        }
        this.sigmaSlider = new JSlider(0, 50, (int)Math.round(this.sigma * 10.0));
        this.sigmaSlider.addChangeListener(this);
        this.sigmaSlider.setLabelTable(labelTable);
        this.sigmaSlider.setMajorTickSpacing(10);
        this.sigmaSlider.setMinorTickSpacing(2);
        this.sigmaSlider.setPaintTicks(true);
        this.sigmaSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("\u03c3:"));
        this.optionPane.add(this.sigmaSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(2, 2));
        this.add((Component)this.canvas, "Center");
        GaussianDistribution dist = new GaussianDistribution(0.0, this.sigma);
        double[][] p = new double[200][2];
        double[][] q = new double[200][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = (double)(i - 100) / 10.0;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = (double)(i - 100) / 10.0;
            q[i][1] = dist.cdf(p[i][0]);
        }
        this.pdf = LinePlot.plot(p, Line.Style.SOLID, Color.BLUE);
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = LinePlot.plot(q, Line.Style.SOLID, Color.BLUE);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
        this.qqplot = QQPlot.plot(data, dist);
        this.qqplot.setTitle("Q-Q Plot");
        this.canvas.add(this.qqplot);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.sigmaSlider) {
            this.sigma = (double)this.sigmaSlider.getValue() / 10.0;
            if (this.sigma == 0.0) {
                this.sigma = 0.01;
            }
            GaussianDistribution dist = new GaussianDistribution(0.0, this.sigma);
            double[][] p = new double[200][2];
            double[][] q = new double[200][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = (double)(i - 100) / 10.0;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = (double)(i - 100) / 10.0;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.line(p, Line.Style.SOLID, Color.BLUE);
            this.cdf.clear();
            this.cdf.line(q, Line.Style.SOLID, Color.BLUE);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
            this.qqplot.clear();
            this.qqplot.add(new QQPlot(data, dist));
            this.canvas.repaint();
        }
    }

    @Override
    public String toString() {
        return "Gaussian";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Gaussian Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new GaussianDistributionDemo());
        frame.setVisible(true);
    }
}

