/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.stat.distribution;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import smile.math.Math;
import smile.plot.Histogram;
import smile.plot.Line;
import smile.plot.LinePlot;
import smile.plot.PlotCanvas;
import smile.plot.QQPlot;
import smile.stat.distribution.BetaDistribution;

public class BetaDistributionDemo
extends JPanel
implements ChangeListener {
    private JPanel optionPane;
    private JPanel canvas;
    private PlotCanvas pdf;
    private PlotCanvas cdf;
    private PlotCanvas histogram;
    private PlotCanvas qqplot;
    private JSlider alphaSlider;
    private JSlider betaSlider;
    private double alpha = 2.0;
    private double beta = 5.0;

    public BetaDistributionDemo() {
        super(new BorderLayout());
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100; i += 20) {
            labelTable.put(new Integer(i), new JLabel(String.valueOf(i / 10)));
        }
        this.alphaSlider = new JSlider(0, 100, (int)Math.round(this.alpha * 10.0));
        this.alphaSlider.addChangeListener(this);
        this.alphaSlider.setLabelTable(labelTable);
        this.alphaSlider.setMajorTickSpacing(10);
        this.alphaSlider.setMinorTickSpacing(2);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setPaintLabels(true);
        this.betaSlider = new JSlider(0, 100, (int)Math.round(this.beta * 10.0));
        this.betaSlider.addChangeListener(this);
        this.betaSlider.setLabelTable(labelTable);
        this.betaSlider.setMajorTickSpacing(10);
        this.betaSlider.setMinorTickSpacing(2);
        this.betaSlider.setPaintTicks(true);
        this.betaSlider.setPaintLabels(true);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(new JLabel("\u03b1:"));
        this.optionPane.add(this.alphaSlider);
        this.optionPane.add(new JLabel("\u03b2:"));
        this.optionPane.add(this.betaSlider);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(2, 2));
        this.add((Component)this.canvas, "Center");
        BetaDistribution dist = new BetaDistribution(this.alpha, this.beta);
        double[][] p = new double[99][2];
        double[][] q = new double[99][2];
        for (int i = 0; i < p.length; ++i) {
            p[i][0] = (double)(i + 1) / 100.0;
            p[i][1] = dist.p(p[i][0]);
            q[i][0] = (double)(i + 1) / 100.0;
            q[i][1] = dist.cdf(p[i][0]);
        }
        this.pdf = LinePlot.plot(p, Line.Style.SOLID, Color.BLUE);
        this.pdf.setTitle("PDF");
        this.canvas.add(this.pdf);
        this.cdf = LinePlot.plot(q, Line.Style.SOLID, Color.BLUE);
        this.cdf.setTitle("CDF");
        this.canvas.add(this.cdf);
        double[] data = new double[500];
        for (int i = 0; i < data.length; ++i) {
            data[i] = dist.rand();
        }
        this.histogram = Histogram.plot(data, 20);
        this.histogram.setTitle("Histogram");
        this.canvas.add(this.histogram);
        this.qqplot = QQPlot.plot(data, dist);
        this.qqplot.setTitle("Q-Q Plot");
        this.canvas.add(this.qqplot);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.alphaSlider || e.getSource() == this.betaSlider) {
            this.alpha = (double)this.alphaSlider.getValue() / 10.0;
            this.beta = (double)this.betaSlider.getValue() / 10.0;
            if (this.alpha == 0.0) {
                this.alpha = 0.01;
            }
            if (this.beta == 0.0) {
                this.beta = 0.01;
            }
            BetaDistribution dist = new BetaDistribution(this.alpha, this.beta);
            double[][] p = new double[99][2];
            double[][] q = new double[99][2];
            for (int i = 0; i < p.length; ++i) {
                p[i][0] = (double)(i + 1) / 100.0;
                p[i][1] = dist.p(p[i][0]);
                q[i][0] = (double)(i + 1) / 100.0;
                q[i][1] = dist.cdf(p[i][0]);
            }
            this.pdf.clear();
            this.pdf.line(p, Line.Style.SOLID, Color.BLUE);
            this.cdf.clear();
            this.cdf.line(q, Line.Style.SOLID, Color.BLUE);
            double[] data = new double[500];
            for (int i = 0; i < data.length; ++i) {
                data[i] = dist.rand();
            }
            this.histogram.clear();
            this.histogram.histogram(data, 20, Color.BLUE);
            this.qqplot.clear();
            this.qqplot.add(new QQPlot(data, dist));
            this.canvas.repaint();
        }
    }

    @Override
    public String toString() {
        return "Beta";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Beta Distribution");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new BetaDistributionDemo());
        frame.setVisible(true);
    }
}

