/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.projection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;

public abstract class ProjectionDemo
extends JPanel
implements Runnable,
ActionListener {
    private static String[] datasetName = new String[]{"IRIS", "US Arrests", "Food Nutrition", "Pen Digits", "COMBO-17"};
    private static String[] datasource = new String[]{"classification/iris.txt", "projection/USArrests.txt", "projection/food.txt", "classification/pendigits.txt", "projection/COMBO17.dat"};
    protected static AttributeDataset[] dataset = new AttributeDataset[datasetName.length];
    protected static int datasetIndex = 0;
    JPanel optionPane;
    JComponent canvas;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    protected char pointLegend = (char)46;

    public ProjectionDemo() {
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
    }

    public abstract JComponent learn();

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        try {
            JComponent plot = this.learn();
            if (plot != null) {
                if (this.canvas != null) {
                    this.remove(this.canvas);
                }
                this.canvas = plot;
                this.add((Component)plot, "Center");
            }
            this.validate();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            datasetIndex = this.datasetBox.getSelectedIndex();
            if (dataset[datasetIndex] == null) {
                DelimitedTextParser parser = new DelimitedTextParser();
                parser.setDelimiter("[\t]+");
                if (datasetIndex < 5 && datasetIndex != 3) {
                    parser.setColumnNames(true);
                }
                if (datasetIndex == 1) {
                    parser.setRowNames(true);
                }
                if (datasetIndex == 0) {
                    parser.setResponseIndex(new NominalAttribute("class"), 4);
                }
                if (datasetIndex == 3) {
                    parser.setResponseIndex(new NominalAttribute("class"), 16);
                }
                if (datasetIndex >= 5) {
                    parser.setResponseIndex(new NominalAttribute("class"), 4);
                }
                try {
                    ProjectionDemo.dataset[ProjectionDemo.datasetIndex] = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                    System.out.println(ex);
                }
            }
            this.pointLegend = dataset[datasetIndex].size() < 500 ? (char)111 : (char)46;
            Thread thread = new Thread(this);
            thread.start();
        }
    }
}

