/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.projection;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.demo.projection.ProjectionDemo;
import smile.math.Math;
import smile.math.kernel.GaussianKernel;
import smile.math.kernel.MercerKernel;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.projection.KPCA;
import smile.projection.PCA;

public class KPCADemo
extends ProjectionDemo {
    private double[] gamma = new double[dataset.length];
    JTextField gammaNumberField = new JTextField(Double.toString(this.gamma[datasetIndex]), 5);

    public KPCADemo() {
        this.optionPane.add(new JLabel("Gaussian Kernel gamma:"));
        this.optionPane.add(this.gammaNumberField);
    }

    @Override
    public JComponent learn() {
        int i;
        int i2;
        int[] labels;
        JPanel pane = new JPanel(new GridLayout(2, 2));
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        String[] names = dataset[datasetIndex].toArray(new String[dataset[datasetIndex].size()]);
        if (names[0] == null) {
            names = null;
        }
        if (this.gamma[datasetIndex] == 0.0) {
            int n = 0;
            for (int i3 = 0; i3 < data.length; ++i3) {
                int j = 0;
                while (j < i3) {
                    int n2 = datasetIndex;
                    this.gamma[n2] = this.gamma[n2] + Math.squaredDistance(data[i3], data[j]);
                    ++j;
                    ++n;
                }
            }
            this.gamma[KPCADemo.datasetIndex] = Math.sqrt(this.gamma[datasetIndex] / (double)n) / 4.0;
        } else {
            try {
                this.gamma[KPCADemo.datasetIndex] = Double.parseDouble(this.gammaNumberField.getText().trim());
                if (this.gamma[datasetIndex] <= 0.0) {
                    JOptionPane.showMessageDialog(this, "Invalid parameter: " + this.gamma[datasetIndex], "Error", 0);
                    return null;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Invalid parameter: " + this.gammaNumberField.getText(), "Error", 0);
                return null;
            }
        }
        this.gammaNumberField.setText(String.format("%.4f", this.gamma[datasetIndex]));
        long clock = System.currentTimeMillis();
        PCA pca = new PCA(data, true);
        System.out.format("Learn PCA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        pca.setProjection(2);
        double[][] y = pca.project(data);
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PCA");
        pane.add(plot);
        pca.setProjection(3);
        y = pca.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PCA");
        pane.add(plot);
        KPCA<double[]> kpca = new KPCA<double[]>((T[])data, (MercerKernel<double[]>)new GaussianKernel(this.gamma[datasetIndex]), 2);
        y = kpca.getCoordinates();
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels2 = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i = 0; i < y.length; ++i) {
                plot.point(this.pointLegend, Palette.COLORS[labels2[i]], y[i]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("KPCA");
        pane.add(plot);
        clock = System.currentTimeMillis();
        kpca = new KPCA<double[]>((T[])data, (MercerKernel<double[]>)new GaussianKernel(this.gamma[datasetIndex]), 3);
        System.out.format("Learn KPCA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        y = kpca.getCoordinates();
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels3 = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i = 0; i < y.length; ++i) {
                plot.point(this.pointLegend, Palette.COLORS[labels3[i]], y[i]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("KPCA");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "Kernel Principal Component Analysis";
    }

    public static void main(String[] argv) {
        KPCADemo demo = new KPCADemo();
        JFrame f = new JFrame("Kernel Principal Component Analysis");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

