/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.projection;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.demo.projection.ProjectionDemo;
import smile.math.Math;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.projection.GHA;
import smile.projection.PCA;

public class GHADemo
extends ProjectionDemo {
    @Override
    public JComponent learn() {
        int i;
        int i2;
        int[] labels;
        JPanel pane = new JPanel(new GridLayout(2, 2));
        double[][] data = Math.clone((double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]));
        String[] names = dataset[datasetIndex].toArray(new String[dataset[datasetIndex].size()]);
        if (names[0] == null) {
            names = null;
        }
        long clock = System.currentTimeMillis();
        PCA pca = new PCA(data, true);
        System.out.format("Learn PCA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        pca.setProjection(2);
        double[][] y = pca.project(data);
        PlotCanvas plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PCA");
        pane.add(plot);
        pca.setProjection(3);
        y = pca.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            labels = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (i2 = 0; i2 < y.length; ++i2) {
                plot.point(this.pointLegend, Palette.COLORS[labels[i2]], y[i2]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("PCA");
        pane.add(plot);
        clock = System.currentTimeMillis();
        GHA gha = new GHA(data[0].length, 2, 1.0E-5);
        for (int iter = 1; iter <= 500; ++iter) {
            double error = 0.0;
            for (i = 0; i < data.length; ++i) {
                error += gha.learn(data[i]);
            }
            error /= (double)data.length;
            if (iter % 100 != 0) continue;
            System.out.format("Iter %3d, Error = %.5g\n", iter, error);
        }
        System.out.format("Learn GHA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        y = gha.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels2 = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (int i3 = 0; i3 < y.length; ++i3) {
                plot.point(this.pointLegend, Palette.COLORS[labels2[i3]], y[i3]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("GHA");
        pane.add(plot);
        clock = System.currentTimeMillis();
        gha = new GHA(data[0].length, 3, 1.0E-5);
        for (int iter = 1; iter <= 500; ++iter) {
            double error = 0.0;
            for (i = 0; i < data.length; ++i) {
                error += gha.learn(data[i]);
            }
            error /= (double)data.length;
            if (iter % 100 != 0) continue;
            System.out.format("Iter %3d, Error = %.5g\n", iter, error);
        }
        System.out.format("Learn GHA from %d samples in %dms\n", data.length, System.currentTimeMillis() - clock);
        y = gha.project(data);
        plot = new PlotCanvas(Math.colMin(y), Math.colMax(y));
        if (names != null) {
            plot.points(y, names);
        } else if (dataset[datasetIndex].responseAttribute() != null) {
            int[] labels3 = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            for (int i4 = 0; i4 < y.length; ++i4) {
                plot.point(this.pointLegend, Palette.COLORS[labels3[i4]], y[i4]);
            }
        } else {
            plot.points(y, this.pointLegend);
        }
        plot.setTitle("GHA");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "Generalized Hebbian Algorithm";
    }

    public static void main(String[] argv) {
        GHADemo demo = new GHADemo();
        JFrame f = new JFrame("Generalized Hebbian Algorithm");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

