/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.plot;

import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.Surface;

public class SurfaceDemo
extends JPanel {
    public SurfaceDemo() {
        super(new GridLayout(1, 2));
        int n = 50;
        int m = 50;
        double[][][] z = new double[m][n][3];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j][0] = 6.0 * (double)(i - m / 2) / (double)m;
                z[i][j][1] = 6.0 * (double)(j - n / 2) / (double)n;
                z[i][j][2] = Math.exp((z[i][j][0] * z[i][j][0] + z[i][j][1] * z[i][j][1]) / -2.0) / Math.sqrt(Math.PI * 2);
            }
        }
        PlotCanvas canvas = Surface.plot(z);
        canvas.setTitle("Gaussian");
        this.add(canvas);
        z = new double[m][n][3];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                z[i][j][0] = 6.0 * (double)(i - m / 2) / (double)m;
                z[i][j][1] = 6.0 * (double)(j - n / 2) / (double)n;
                double t = z[i][j][0] * z[i][j][0] + z[i][j][1] * z[i][j][1];
                z[i][j][2] = (1.0 - t) * Math.exp(t / -2.0) / Math.sqrt(Math.PI * 2);
            }
        }
        canvas = Surface.plot(z, Palette.jet(256, 1.0f));
        canvas.setTitle("Mexican Hat");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Surface";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Surface Plot");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new SurfaceDemo());
        frame.setVisible(true);
    }
}

