/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.plot;

import java.awt.GridLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import smile.math.Math;
import smile.plot.Histogram3D;
import smile.plot.Palette;
import smile.plot.PlotCanvas;

public class Histogram3Demo
extends JPanel {
    public Histogram3Demo() {
        super(new GridLayout(1, 2));
        double[][] data = new double[10000][2];
        for (int j = 0; j < data.length; ++j) {
            double y;
            double x;
            double r;
            while ((r = (x = 2.0 * (Math.random() - 0.5)) * x + (y = 2.0 * (Math.random() - 0.5)) * y) >= 1.0) {
            }
            double z = Math.sqrt(-2.0 * Math.log(r) / r);
            data[j][0] = new Double(x * z);
            data[j][1] = new Double(y * z);
        }
        PlotCanvas canvas = Histogram3D.plot(data, 20);
        canvas.setTitle("Histogram 3D");
        this.add(canvas);
        canvas = Histogram3D.plot(data, 20, Palette.jet(16));
        canvas.setTitle("Histogram 3D with Colormap");
        this.add(canvas);
    }

    @Override
    public String toString() {
        return "Histogram 3D";
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Histogram 3D");
        frame.setDefaultCloseOperation(3);
        frame.setLocationRelativeTo(null);
        frame.getContentPane().add(new Histogram3Demo());
        frame.setVisible(true);
    }
}

