/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.neighbor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.LSH;
import smile.neighbor.LinearSearch;
import smile.neighbor.MPLSH;
import smile.neighbor.Neighbor;
import smile.plot.BarPlot;
import smile.plot.PlotCanvas;

public class KNNDemo
extends JPanel
implements Runnable,
ActionListener {
    private String[] label = new String[]{"Naive", "KD-Tree", "Cover Tree", "LSH", "MPLSH"};
    private JPanel optionPane;
    private JPanel canvas;
    private JButton startButton = new JButton("Start");
    private JSlider logNSlider;
    private JSlider dimensionSlider;
    private JTextField knnField;
    private int logN = 4;
    private int dimension = 10;
    private int knn = 3;

    public KNNDemo() {
        super(new BorderLayout());
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        Hashtable<Integer, JLabel> logNLabelTable = new Hashtable<Integer, JLabel>();
        for (int i = 3; i <= 7; ++i) {
            logNLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.logNSlider = new JSlider(3, 7, this.logN);
        this.logNSlider.setLabelTable(logNLabelTable);
        this.logNSlider.setMajorTickSpacing(1);
        this.logNSlider.setPaintTicks(true);
        this.logNSlider.setPaintLabels(true);
        Hashtable<Integer, JLabel> dimensionLabelTable = new Hashtable<Integer, JLabel>();
        dimensionLabelTable.put(new Integer(2), new JLabel(String.valueOf(2)));
        for (int i = 20; i <= 120; i += 20) {
            dimensionLabelTable.put(new Integer(i), new JLabel(String.valueOf(i)));
        }
        this.dimensionSlider = new JSlider(2, 128, this.dimension);
        this.dimensionSlider.setLabelTable(dimensionLabelTable);
        this.dimensionSlider.setMajorTickSpacing(20);
        this.dimensionSlider.setMinorTickSpacing(5);
        this.dimensionSlider.setPaintTicks(true);
        this.dimensionSlider.setPaintLabels(true);
        this.knnField = new JTextField(Integer.toString(this.knn), 5);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("log N:"));
        this.optionPane.add(this.logNSlider);
        this.optionPane.add(new JLabel("Dimension:"));
        this.optionPane.add(this.dimensionSlider);
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.knnField);
        this.add((Component)this.optionPane, "North");
        this.canvas = new JPanel(new GridLayout(1, 2));
        this.canvas.setBackground(Color.WHITE);
        this.add((Component)this.canvas, "Center");
    }

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.logNSlider.setEnabled(false);
        this.dimensionSlider.setEnabled(false);
        this.knnField.setEnabled(false);
        this.logN = this.logNSlider.getValue();
        this.dimension = this.dimensionSlider.getValue();
        System.out.println("Generating dataset...");
        int n = (int)Math.pow(10.0, (double)this.logN);
        double[][] data = new double[n][];
        for (int i = 0; i < n; ++i) {
            data[i] = new double[this.dimension];
            for (int j = 0; j < this.dimension; ++j) {
                data[i][j] = Math.random();
            }
        }
        int[] perm = Math.permutate(n);
        System.out.println("Building searching data structure...");
        long time = System.currentTimeMillis();
        LinearSearch<double[]> naive = new LinearSearch<double[]>(data, new EuclideanDistance());
        int naiveBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        KDTree<double[]> kdtree = new KDTree<double[]>(data, (E[])data);
        int kdtreeBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        CoverTree<double[]> cover = new CoverTree<double[]>(data, new EuclideanDistance());
        int coverBuild = (int)(System.currentTimeMillis() - time);
        System.out.println("Perform 1000 searches...");
        double radius = 0.0;
        ArrayList<Neighbor<double[], double[]>[]> answers = new ArrayList<Neighbor<double[], double[]>[]>(1000);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            answers.add(naive.knn(data[perm[i]], this.knn));
            for (int j = 0; j < ((Neighbor[])answers.get(i)).length; ++j) {
                radius += ((Neighbor[])answers.get((int)i))[j].distance;
            }
        }
        int naiveSearch = (int)(System.currentTimeMillis() - time);
        radius /= (double)(1000 * this.knn);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            kdtree.knn(data[perm[i]], this.knn);
        }
        int kdtreeSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            cover.knn(data[perm[i]], this.knn);
        }
        int coverSearch = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        LSH<double[]> lsh = new LSH<double[]>(this.dimension, 5, (int)Math.log2(this.dimension), 4.0 * radius, 1017881);
        for (int i = 0; i < n; ++i) {
            lsh.put(data[i], data[i]);
        }
        int lshBuild = (int)(System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        MPLSH<double[]> mplsh = new MPLSH<double[]>(this.dimension, 2, (int)Math.log2(n), 4.0 * radius, 1017881);
        for (int i = 0; i < n; ++i) {
            mplsh.put(data[i], data[i]);
        }
        double[][] train = new double[1000][];
        for (int i = 0; i < train.length; ++i) {
            train[i] = data[perm[i]];
        }
        mplsh.learn(kdtree, train, 1.5 * radius);
        int mplshBuild = (int)(System.currentTimeMillis() - time);
        double lshRecall = 0.0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            Neighbor<double[], E>[] neighbors = lsh.knn(data[perm[i]], this.knn);
            int hit = 0;
            block10: for (int p = 0; p < this.knn && ((Neighbor[])answers.get(i))[p] != null; ++p) {
                for (int q = 0; q < this.knn && neighbors[q] != null; ++q) {
                    if (((Neighbor[])answers.get((int)i))[p].index != neighbors[q].index) continue;
                    ++hit;
                    continue block10;
                }
            }
            lshRecall += 1.0 * (double)hit / (double)this.knn;
        }
        int lshSearch = (int)(System.currentTimeMillis() - time);
        System.out.format("The recall of LSH is %.1f%%\n", (lshRecall /= 1000.0) * 100.0);
        double mplshRecall = 0.0;
        time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            Neighbor<double[], E>[] neighbors = mplsh.knn(data[perm[i]], this.knn, 0.95, 10);
            int hit = 0;
            block13: for (int p = 0; p < this.knn && ((Neighbor[])answers.get(i))[p] != null; ++p) {
                for (int q = 0; q < this.knn && neighbors[q] != null; ++q) {
                    if (((Neighbor[])answers.get((int)i))[p].index != neighbors[q].index) continue;
                    ++hit;
                    continue block13;
                }
            }
            mplshRecall += 1.0 * (double)hit / (double)this.knn;
        }
        int mplshSearch = (int)(System.currentTimeMillis() - time);
        System.out.format("The recall of MPLSH is %.1f%%\n", (mplshRecall /= 1000.0) * 100.0);
        this.canvas.removeAll();
        double[] buildTime = new double[]{naiveBuild, kdtreeBuild, coverBuild, lshBuild, mplshBuild};
        PlotCanvas build = BarPlot.plot(buildTime, this.label);
        build.setTitle("Build Time");
        this.canvas.add(build);
        double[] searchTime = new double[]{naiveSearch, kdtreeSearch, coverSearch, lshSearch, mplshSearch};
        PlotCanvas search = BarPlot.plot(searchTime, this.label);
        search.setTitle("Search Time");
        this.canvas.add(search);
        this.validate();
        this.startButton.setEnabled(true);
        this.logNSlider.setEnabled(true);
        this.dimensionSlider.setEnabled(true);
        this.knnField.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            try {
                this.knn = Integer.parseInt(this.knnField.getText().trim());
                if (this.knn < 1) {
                    JOptionPane.showMessageDialog(this, "Invalid K: " + this.knn, "Error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.knnField.getText(), "Error", 0);
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    @Override
    public String toString() {
        return "KNN";
    }

    public static void main(String[] argv) {
        KNNDemo demo = new KNNDemo();
        JFrame f = new JFrame("KNN");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

