/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.manifold;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import smile.data.AttributeDataset;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;

public abstract class ManifoldDemo
extends JPanel
implements Runnable,
ActionListener {
    int k = 7;
    private JTextField knnField;
    private static String[] datasetName = new String[]{"Swiss Roll", "Face"};
    private static String[] datasource = new String[]{"manifold/swissroll.txt", "manifold/face.txt"};
    static AttributeDataset[] dataset = new AttributeDataset[datasetName.length];
    static int datasetIndex = 0;
    JPanel optionPane;
    JComponent canvas;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    char pointLegend = (char)46;

    public ManifoldDemo() {
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.knnField = new JTextField(Integer.toString(this.k), 5);
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.knnField);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
    }

    public abstract JComponent learn();

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        this.knnField.setEnabled(false);
        try {
            JComponent plot = this.learn();
            if (plot != null) {
                if (this.canvas != null) {
                    this.remove(this.canvas);
                }
                this.canvas = plot;
                this.add((Component)plot, "Center");
            }
            this.validate();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
        this.knnField.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            double[][] data;
            datasetIndex = this.datasetBox.getSelectedIndex();
            if (dataset[datasetIndex] == null) {
                DelimitedTextParser parser = new DelimitedTextParser();
                parser.setDelimiter("[\t]+");
                try {
                    ManifoldDemo.dataset[ManifoldDemo.datasetIndex] = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                    System.err.println(ex);
                }
            }
            this.pointLegend = (data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][])).length < 500 ? (char)111 : (char)46;
            try {
                this.k = Integer.parseInt(this.knnField.getText().trim());
                if (this.k < 2 || this.k > 30) {
                    JOptionPane.showMessageDialog(this, "Invalid K: " + this.k, "Error", 0);
                    return;
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.knnField.getText(), "Error", 0);
                return;
            }
            Thread thread = new Thread(this);
            thread.start();
        }
    }
}

