/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;
import smile.vq.NeuralGas;

public class NeuralGasDemo
extends ClusteringDemo {
    @Override
    public JComponent learn() {
        long clock = System.currentTimeMillis();
        NeuralGas gas = new NeuralGas(dataset[datasetIndex], clusterNumber);
        System.out.format("Neural Gas clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(gas.centroids(), '@');
        for (int k = 0; k < clusterNumber; ++k) {
            if (gas.getClusterSize()[k] <= 0) continue;
            double[][] cluster = new double[gas.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (gas.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot.points(gas.centroids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "Neural Gas";
    }

    public static void main(String[] argv) {
        NeuralGasDemo demo = new NeuralGasDemo();
        JFrame f = new JFrame("Neural Gas");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

