/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import smile.clustering.KMeans;
import smile.demo.clustering.ClusteringDemo;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class KMeansDemo
extends ClusteringDemo {
    @Override
    public JComponent learn() {
        long clock = System.currentTimeMillis();
        KMeans kmeans = new KMeans(dataset[datasetIndex], clusterNumber, 100, 4);
        System.out.format("K-Means clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], kmeans.getClusterLabel(), this.pointLegend, Palette.COLORS);
        plot.points(kmeans.centroids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "K-Means";
    }

    public static void main(String[] argv) {
        KMeansDemo demo = new KMeansDemo();
        JFrame f = new JFrame("K-Means");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

