/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import smile.clustering.HierarchicalClustering;
import smile.clustering.linkage.CompleteLinkage;
import smile.clustering.linkage.SingleLinkage;
import smile.clustering.linkage.UPGMALinkage;
import smile.clustering.linkage.UPGMCLinkage;
import smile.clustering.linkage.WPGMALinkage;
import smile.clustering.linkage.WPGMCLinkage;
import smile.clustering.linkage.WardLinkage;
import smile.demo.clustering.ClusteringDemo;
import smile.math.Math;
import smile.plot.Dendrogram;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class HierarchicalClusteringDemo
extends ClusteringDemo {
    JComboBox<String> linkageBox = new JComboBox();

    public HierarchicalClusteringDemo() {
        this.linkageBox.addItem("Single");
        this.linkageBox.addItem("Complete");
        this.linkageBox.addItem("UPGMA");
        this.linkageBox.addItem("WPGMA");
        this.linkageBox.addItem("UPGMC");
        this.linkageBox.addItem("WPGMC");
        this.linkageBox.addItem("Ward");
        this.linkageBox.setSelectedIndex(0);
        this.optionPane.add(new JLabel("Linkage:"));
        this.optionPane.add(this.linkageBox);
    }

    @Override
    public JComponent learn() {
        long clock = System.currentTimeMillis();
        double[][] data = dataset[datasetIndex];
        int n = data.length;
        double[][] proximity = new double[n][];
        for (int i = 0; i < n; ++i) {
            proximity[i] = new double[i + 1];
            for (int j = 0; j < i; ++j) {
                proximity[i][j] = Math.distance(data[i], data[j]);
            }
        }
        HierarchicalClustering hac = null;
        switch (this.linkageBox.getSelectedIndex()) {
            case 0: {
                hac = new HierarchicalClustering(new SingleLinkage(proximity));
                break;
            }
            case 1: {
                hac = new HierarchicalClustering(new CompleteLinkage(proximity));
                break;
            }
            case 2: {
                hac = new HierarchicalClustering(new UPGMALinkage(proximity));
                break;
            }
            case 3: {
                hac = new HierarchicalClustering(new WPGMALinkage(proximity));
                break;
            }
            case 4: {
                hac = new HierarchicalClustering(new UPGMCLinkage(proximity));
                break;
            }
            case 5: {
                hac = new HierarchicalClustering(new WPGMCLinkage(proximity));
                break;
            }
            case 6: {
                hac = new HierarchicalClustering(new WardLinkage(proximity));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported Linkage");
            }
        }
        System.out.format("Hierarchical clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        int[] membership = hac.partition(clusterNumber);
        int[] clusterSize = new int[clusterNumber];
        for (int i = 0; i < membership.length; ++i) {
            int n2 = membership[i];
            clusterSize[n2] = clusterSize[n2] + 1;
        }
        JPanel pane = new JPanel(new GridLayout(1, 3));
        PlotCanvas plot = ScatterPlot.plot(dataset[datasetIndex], this.pointLegend);
        plot.setTitle("Data");
        pane.add(plot);
        for (int k = 0; k < clusterNumber; ++k) {
            double[][] cluster = new double[clusterSize[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (membership[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot = Dendrogram.plot("Dendrogram", hac.getTree(), hac.getHeight());
        plot.setTitle("Dendrogram");
        pane.add(plot);
        return pane;
    }

    @Override
    public String toString() {
        return "Hierarchical Agglomerative Clustering";
    }

    public static void main(String[] argv) {
        HierarchicalClusteringDemo demo = new HierarchicalClusteringDemo();
        JFrame f = new JFrame("Agglomerative Hierarchical Clustering");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

