/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.clustering;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.clustering.CLARANS;
import smile.demo.clustering.ClusteringDemo;
import smile.math.distance.EuclideanDistance;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public class CLARANSDemo
extends ClusteringDemo {
    private static final String ERROR = "Error";
    JTextField numLocalField = new JTextField(Integer.toString(this.numLocal), 5);
    int numLocal = 10;
    JTextField maxNeighborField = new JTextField(Integer.toString(this.maxNeighbor), 5);
    int maxNeighbor = 20;

    public CLARANSDemo() {
        this.optionPane.add(new JLabel("NumLocal:"));
        this.optionPane.add(this.numLocalField);
        this.optionPane.add(new JLabel("MaxNeighbor:"));
        this.optionPane.add(this.maxNeighborField);
    }

    @Override
    public JComponent learn() {
        try {
            this.numLocal = Integer.parseInt(this.numLocalField.getText().trim());
            if (this.numLocal < 5) {
                JOptionPane.showMessageDialog(this, "Toll smal NumLocal: " + this.numLocal, ERROR, 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid NumLocal: " + this.numLocalField.getText(), ERROR, 0);
            return null;
        }
        try {
            this.maxNeighbor = Integer.parseInt(this.maxNeighborField.getText().trim());
            if (this.maxNeighbor < 5) {
                JOptionPane.showMessageDialog(this, "Too small MaxNeighbor: " + this.maxNeighbor, ERROR, 0);
                return null;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Invalid MaxNeighbor: " + this.maxNeighborField.getText(), ERROR, 0);
            return null;
        }
        long clock = System.currentTimeMillis();
        CLARANS<double[]> clarans = new CLARANS<double[]>((T[])dataset[datasetIndex], new EuclideanDistance(), clusterNumber, this.maxNeighbor, this.numLocal);
        System.out.format("CLARANS clusterings %d samples in %dms\n", dataset[datasetIndex].length, System.currentTimeMillis() - clock);
        PlotCanvas plot = ScatterPlot.plot((double[][])clarans.medoids(), '@');
        for (int k = 0; k < clusterNumber; ++k) {
            if (clarans.getClusterSize()[k] <= 0) continue;
            double[][] cluster = new double[clarans.getClusterSize()[k]][];
            int j = 0;
            for (int i = 0; i < dataset[datasetIndex].length; ++i) {
                if (clarans.getClusterLabel()[i] != k) continue;
                cluster[j++] = dataset[datasetIndex][i];
            }
            plot.points((double[][])cluster, this.pointLegend, Palette.COLORS[k % Palette.COLORS.length]);
        }
        plot.points((double[][])clarans.medoids(), '@');
        return plot;
    }

    @Override
    public String toString() {
        return "CLARANS";
    }

    public static void main(String[] argv) {
        CLARANSDemo demo = new CLARANSDemo();
        JFrame f = new JFrame("CLARANS");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

