/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.classification;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import smile.classification.RBFNetwork;
import smile.demo.classification.ClassificationDemo;
import smile.math.distance.EuclideanDistance;
import smile.math.distance.Metric;
import smile.math.rbf.GaussianRadialBasis;
import smile.util.SmileUtils;

public class RBFNetworkDemo
extends ClassificationDemo {
    private int k = 10;
    private JTextField kField = new JTextField(Integer.toString(this.k), 5);

    public RBFNetworkDemo() {
        this.optionPane.add(new JLabel("K:"));
        this.optionPane.add(this.kField);
    }

    @Override
    public double[][] learn(double[] x, double[] y) {
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        try {
            this.k = Integer.parseInt(this.kField.getText().trim());
            if (this.k < 2 || this.k > data.length) {
                JOptionPane.showMessageDialog(this, "Invalid K: " + this.k, "Error", 0);
                return null;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid K: " + this.kField.getText(), "Error", 0);
            return null;
        }
        double[][] centers = new double[this.k][];
        GaussianRadialBasis basis = SmileUtils.learnGaussianRadialBasis(data, centers);
        RBFNetwork<double[]> rbf = new RBFNetwork<double[]>((T[])data, label, (Metric<double[]>)new EuclideanDistance(), basis, (T[])centers);
        for (int i = 0; i < label.length; ++i) {
            label[i] = rbf.predict(data[i]);
        }
        double trainError = this.error(label, label);
        System.out.format("training error = %.2f%%\n", 100.0 * trainError);
        double[][] z = new double[y.length][x.length];
        for (int i = 0; i < y.length; ++i) {
            for (int j = 0; j < x.length; ++j) {
                double[] p = new double[]{x[j], y[i]};
                z[i][j] = rbf.predict(p);
            }
        }
        return z;
    }

    @Override
    public String toString() {
        return "RBF Networks";
    }

    public static void main(String[] argv) {
        RBFNetworkDemo demo = new RBFNetworkDemo();
        JFrame f = new JFrame("RBF Networks");
        f.setSize(new Dimension(1000, 1000));
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(demo);
        f.setVisible(true);
    }
}

