/*
 * Decompiled with CFR 0.152.
 */
package smile.demo.classification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.plot.Contour;
import smile.plot.Palette;
import smile.plot.PlotCanvas;
import smile.plot.ScatterPlot;

public abstract class ClassificationDemo
extends JPanel
implements Runnable,
ActionListener,
AncestorListener {
    private static String[] datasetName = new String[]{"Toy", "Big Toy"};
    private static String[] datasource = new String[]{"classification/toy/toy-train.txt", "classification/toy/toy-test.txt"};
    static AttributeDataset[] dataset = null;
    static int datasetIndex = 0;
    JPanel optionPane;
    private JButton startButton;
    private JComboBox<String> datasetBox;
    char pointLegend = (char)111;

    public ClassificationDemo() {
        if (dataset == null) {
            dataset = new AttributeDataset[datasetName.length];
            DelimitedTextParser parser = new DelimitedTextParser();
            parser.setDelimiter("[\t ]+");
            parser.setResponseIndex(new NominalAttribute("class"), 0);
            try {
                ClassificationDemo.dataset[ClassificationDemo.datasetIndex] = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                System.err.println(e);
            }
        }
        this.addAncestorListener(this);
        this.startButton = new JButton("Start");
        this.startButton.setActionCommand("startButton");
        this.startButton.addActionListener(this);
        this.datasetBox = new JComboBox();
        for (int i = 0; i < datasetName.length; ++i) {
            this.datasetBox.addItem(datasetName[i]);
        }
        this.datasetBox.setSelectedIndex(0);
        this.datasetBox.setActionCommand("datasetBox");
        this.datasetBox.addActionListener(this);
        this.optionPane = new JPanel(new FlowLayout(0));
        this.optionPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.optionPane.add(this.startButton);
        this.optionPane.add(new JLabel("Dataset:"));
        this.optionPane.add(this.datasetBox);
        this.setLayout(new BorderLayout());
        this.add((Component)this.optionPane, "North");
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        this.pointLegend = data.length < 500 ? (char)111 : (char)46;
        PlotCanvas canvas = ScatterPlot.plot(data, this.pointLegend);
        for (int i = 0; i < data.length; ++i) {
            canvas.point(this.pointLegend, Palette.COLORS[label[i]], data[i]);
        }
        this.add((Component)canvas, "Center");
    }

    double error(int[] x, int[] y) {
        int e = 0;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            ++e;
        }
        return (double)e / (double)x.length;
    }

    public abstract double[][] learn(double[] var1, double[] var2);

    @Override
    public void run() {
        this.startButton.setEnabled(false);
        this.datasetBox.setEnabled(false);
        double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
        int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
        this.pointLegend = data.length < 500 ? (char)111 : (char)46;
        PlotCanvas canvas = ScatterPlot.plot(data, this.pointLegend);
        for (int i = 0; i < data.length; ++i) {
            canvas.point(this.pointLegend, Palette.COLORS[label[i]], data[i]);
        }
        double[] lower = canvas.getLowerBounds();
        double[] upper = canvas.getUpperBounds();
        double[] x = new double[50];
        double step = (upper[0] - lower[0]) / (double)x.length;
        for (int i = 0; i < x.length; ++i) {
            x[i] = lower[0] + step * (double)(i + 1);
        }
        double[] y = new double[50];
        step = (upper[1] - lower[1]) / (double)y.length;
        for (int i = 0; i < y.length; ++i) {
            y[i] = lower[1] + step * (double)(i + 1);
        }
        try {
            double[][] f = this.learn(x, y);
            if (f != null) {
                for (int i = 0; i < y.length; ++i) {
                    for (int j = 0; j < x.length; ++j) {
                        double[] p = new double[]{x[j], y[i]};
                        canvas.point('.', Palette.COLORS[(int)f[i][j]], p);
                    }
                }
                double[] levels = new double[]{0.5};
                Contour contour = new Contour(x, y, f, levels);
                contour.showLevelValue(false);
                canvas.add(contour);
                BorderLayout layout = (BorderLayout)this.getLayout();
                this.remove(layout.getLayoutComponent("Center"));
                this.add((Component)canvas, "Center");
                this.validate();
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
        this.startButton.setEnabled(true);
        this.datasetBox.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("startButton".equals(e.getActionCommand())) {
            Thread thread = new Thread(this);
            thread.start();
        } else if ("datasetBox".equals(e.getActionCommand())) {
            datasetIndex = this.datasetBox.getSelectedIndex();
            if (dataset[datasetIndex] == null) {
                DelimitedTextParser parser = new DelimitedTextParser();
                parser.setDelimiter("[\t ]+");
                parser.setResponseIndex(new NominalAttribute("class"), 0);
                try {
                    ClassificationDemo.dataset[ClassificationDemo.datasetIndex] = parser.parse(datasetName[datasetIndex], IOUtils.getTestDataFile(datasource[datasetIndex]));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Failed to load dataset.", "ERROR", 0);
                    System.err.println(ex);
                }
            }
            double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
            int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            this.pointLegend = data.length < 500 ? (char)111 : (char)46;
            PlotCanvas canvas = ScatterPlot.plot(data, this.pointLegend);
            for (int i = 0; i < data.length; ++i) {
                canvas.point(this.pointLegend, Palette.COLORS[label[i]], data[i]);
            }
            BorderLayout layout = (BorderLayout)this.getLayout();
            this.remove(layout.getLayoutComponent("Center"));
            this.add((Component)canvas, "Center");
            this.validate();
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        if (this.datasetBox.getSelectedIndex() != datasetIndex) {
            this.datasetBox.setSelectedIndex(datasetIndex);
            double[][] data = (double[][])dataset[datasetIndex].toArray((E[])new double[dataset[datasetIndex].size()][]);
            int[] label = dataset[datasetIndex].toArray(new int[dataset[datasetIndex].size()]);
            PlotCanvas canvas = ScatterPlot.plot(data, 'o');
            for (int i = 0; i < data.length; ++i) {
                canvas.point('o', Palette.COLORS[label[i]], data[i]);
            }
            BorderLayout layout = (BorderLayout)this.getLayout();
            this.remove(layout.getLayoutComponent("Center"));
            this.add((Component)canvas, "Center");
            this.validate();
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }
}

