/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.clustering.SIB;
import smile.data.SparseDataset;
import smile.data.parser.IOUtils;
import smile.data.parser.LibsvmParser;
import smile.math.SparseArray;
import smile.validation.AdjustedRandIndex;
import smile.validation.RandIndex;

public class SIBTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testParseNG20() throws Exception {
        System.out.println("NG20");
        LibsvmParser parser = new LibsvmParser();
        try {
            SparseDataset train = parser.parse("NG20 Train", IOUtils.getTestDataFile("libsvm/news20.dat"));
            SparseDataset test = parser.parse("NG20 Test", IOUtils.getTestDataFile("libsvm/news20.t.dat"));
            int[] y = train.toArray(new int[train.size()]);
            int[] testy = test.toArray(new int[test.size()]);
            SIB sib = new SIB(train, 20, 100, 8);
            System.out.println(sib);
            AdjustedRandIndex ari = new AdjustedRandIndex();
            RandIndex rand = new RandIndex();
            double r = rand.measure(y, sib.getClusterLabel());
            double r2 = ari.measure(y, sib.getClusterLabel());
            System.out.format("Training rand index = %.2f%%\tadjusted rand index = %.2f%%%n", 100.0 * r, 100.0 * r2);
            Assert.assertTrue(r > 0.85);
            Assert.assertTrue(r2 > 0.2);
            int[] p = new int[test.size()];
            for (int i = 0; i < test.size(); ++i) {
                p[i] = sib.predict((SparseArray)test.get((int)i).x);
            }
            r = rand.measure(testy, p);
            r2 = ari.measure(testy, p);
            System.out.format("Testing rand index = %.2f%%\tadjusted rand index = %.2f%%%n", 100.0 * r, 100.0 * r2);
            Assert.assertTrue(r > 0.85);
            Assert.assertTrue(r2 > 0.2);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

