/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.clustering.PartitionClustering;
import smile.math.Math;
import smile.math.distance.Distance;
import smile.util.MulticoreExecutor;

public class CLARANS<T>
extends PartitionClustering<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CLARANS.class);
    double distortion;
    private Distance<T> distance;
    private int numLocal;
    private int maxNeighbor;
    T[] medoids;

    public CLARANS(T[] data, Distance<T> distance, int k) {
        this(data, distance, k, (int)Math.round(0.0125 * (double)k * (double)(data.length - k)));
    }

    public CLARANS(T[] data, Distance<T> distance, int k, int maxNeighbor) {
        this(data, distance, k, maxNeighbor, Math.max(2, MulticoreExecutor.getThreadPoolSize()));
    }

    public CLARANS(T[] data, Distance<T> distance, int k, int maxNeighbor, int numLocal) {
        if (maxNeighbor <= 0) {
            throw new IllegalArgumentException("Invalid maxNeighbor: " + maxNeighbor);
        }
        if (numLocal <= 0) {
            throw new IllegalArgumentException("Invalid numLocal: " + numLocal);
        }
        int n = data.length;
        if (k >= n) {
            throw new IllegalArgumentException("Too large k: " + k);
        }
        if (maxNeighbor > n) {
            throw new IllegalArgumentException("Too large maxNeighbor: " + maxNeighbor);
        }
        int minmax = 100;
        if (k * (n - k) < minmax) {
            minmax = k * (n - k);
        }
        if (maxNeighbor < minmax) {
            maxNeighbor = minmax;
        }
        this.k = k;
        this.distance = distance;
        this.numLocal = numLocal;
        this.maxNeighbor = maxNeighbor;
        ArrayList<CLARANSTask> tasks = new ArrayList<CLARANSTask>();
        for (int i = 0; i < numLocal; ++i) {
            tasks.add(new CLARANSTask(data));
        }
        try {
            MulticoreExecutor.run(tasks);
        }
        catch (Exception e) {
            logger.error("Failed to run CLARANS on multi-core", e);
            for (CLARANSTask task : tasks) {
                task.call();
            }
        }
        this.distortion = Double.POSITIVE_INFINITY;
        for (CLARANSTask task : tasks) {
            if (!(task.distortion < this.distortion)) continue;
            this.distortion = task.distortion;
            this.medoids = task.medoids;
            this.y = task.y;
        }
        this.size = new int[k];
        for (int i = 0; i < n; ++i) {
            int n2 = this.y[i];
            this.size[n2] = this.size[n2] + 1;
        }
    }

    private double getRandomNeighbor(T[] data, T[] medoids, int[] y, double[] d) {
        int i;
        boolean dup;
        int n = data.length;
        int index = Math.randomInt(this.k);
        Object medoid = null;
        block0: do {
            dup = false;
            medoid = data[Math.randomInt(n)];
            for (i = 0; i < this.k; ++i) {
                if (medoid != medoids[i]) continue;
                dup = true;
                continue block0;
            }
        } while (dup);
        medoids[index] = medoid;
        for (i = 0; i < n; ++i) {
            double dist = this.distance.d(data[i], medoid);
            if (d[i] > dist) {
                y[i] = index;
                d[i] = dist;
                continue;
            }
            if (y[i] != index) continue;
            d[i] = dist;
            y[i] = index;
            for (int j = 0; j < this.k; ++j) {
                if (j == index || !(d[i] > (dist = this.distance.d(data[i], medoids[j])))) continue;
                y[i] = j;
                d[i] = dist;
            }
        }
        return Math.sum(d);
    }

    public int getNumLocalMinima() {
        return this.numLocal;
    }

    public int getMaxNeighbor() {
        return this.maxNeighbor;
    }

    public double distortion() {
        return this.distortion;
    }

    public T[] medoids() {
        return this.medoids;
    }

    @Override
    public int predict(T x) {
        double minDist = Double.MAX_VALUE;
        int bestCluster = 0;
        for (int i = 0; i < this.k; ++i) {
            double dist = this.distance.d(x, this.medoids[i]);
            if (!(dist < minDist)) continue;
            minDist = dist;
            bestCluster = i;
        }
        return bestCluster;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CLARANS distortion: %.5f%n", this.distortion));
        sb.append(String.format("Clusters of %d data points:%n", this.y.length));
        for (int i = 0; i < this.k; ++i) {
            int r = (int)Math.round(1000.0 * (double)this.size[i] / (double)this.y.length);
            sb.append(String.format("%3d\t%5d (%2d.%1d%%)%n", i, this.size[i], r / 10, r % 10));
        }
        return sb.toString();
    }

    class CLARANSTask
    implements Callable<CLARANSTask> {
        final T[] data;
        double distortion;
        T[] medoids;
        int[] y;

        CLARANSTask(T[] data) {
            this.data = data;
        }

        @Override
        public CLARANSTask call() {
            int n = this.data.length;
            this.medoids = (Object[])Array.newInstance(this.data.getClass().getComponentType(), CLARANS.this.k);
            Object[] newMedoids = (Object[])this.medoids.clone();
            this.y = new int[n];
            int[] newY = new int[n];
            double[] d = new double[n];
            double[] newD = new double[n];
            this.distortion = PartitionClustering.seed(CLARANS.this.distance, this.data, this.medoids, this.y, d);
            System.arraycopy(this.medoids, 0, newMedoids, 0, CLARANS.this.k);
            System.arraycopy(this.y, 0, newY, 0, n);
            System.arraycopy(d, 0, newD, 0, n);
            for (int neighborCount = 1; neighborCount <= CLARANS.this.maxNeighbor; ++neighborCount) {
                double randomNeighborDistortion = CLARANS.this.getRandomNeighbor(this.data, newMedoids, newY, newD);
                if (randomNeighborDistortion < this.distortion) {
                    neighborCount = 0;
                    this.distortion = randomNeighborDistortion;
                    System.arraycopy(newMedoids, 0, this.medoids, 0, CLARANS.this.k);
                    System.arraycopy(newY, 0, this.y, 0, n);
                    System.arraycopy(newD, 0, d, 0, n);
                    continue;
                }
                System.arraycopy(this.medoids, 0, newMedoids, 0, CLARANS.this.k);
                System.arraycopy(this.y, 0, newY, 0, n);
                System.arraycopy(d, 0, newD, 0, n);
            }
            return this;
        }
    }
}

