/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.RandomForest;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.sort.QuickSort;
import smile.validation.LOOCV;

public class RandomForestTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testWeather() {
        System.out.println("Weather");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset weather = arffParser.parse(IOUtils.getTestDataFile("weka/weather.nominal.arff"));
            double[][] x = (double[][])weather.toArray((E[])new double[weather.size()][]);
            int[] y = weather.toArray(new int[weather.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                RandomForest forest = new RandomForest(weather.attributes(), trainx, trainy, 100);
                if (y[loocv.test[i]] == forest.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Random Forest error = " + error);
            Assert.assertTrue(error <= 7);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testIris() {
        System.out.println("Iris");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                RandomForest forest = new RandomForest(iris.attributes(), trainx, trainy, 100);
                if (y[loocv.test[i]] == forest.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Random Forest error = " + error);
            Assert.assertTrue(error <= 9);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            RandomForest forest = new RandomForest(x, y, 200);
            int error = 0;
            for (int i = 0; i < testx.length; ++i) {
                if (forest.predict(testx[i]) == testy[i]) continue;
                ++error;
            }
            System.out.println("USPS error = " + error);
            System.out.format("USPS OOB error rate = %.2f%%%n", 100.0 * forest.error());
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error <= 225);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPSNominal() {
        System.out.println("USPS nominal");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            int i;
            int i2;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            for (double[] xi : x) {
                for (i2 = 0; i2 < xi.length; ++i2) {
                    xi[i2] = Math.round(255.0 * (xi[i2] + 1.0) / 2.0);
                }
            }
            for (double[] xi : testx) {
                for (i2 = 0; i2 < xi.length; ++i2) {
                    xi[i2] = Math.round(255.0 * (xi[i2] + 1.0) / 2.0);
                }
            }
            Attribute[] attributes = new Attribute[256];
            String[] values = new String[attributes.length];
            for (i = 0; i < attributes.length; ++i) {
                values[i] = String.valueOf(i);
            }
            for (i = 0; i < attributes.length; ++i) {
                attributes[i] = new NominalAttribute("V" + i, values);
            }
            RandomForest forest = new RandomForest(attributes, x, y, 200);
            int error = 0;
            for (i2 = 0; i2 < testx.length; ++i2) {
                if (forest.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.println(error);
            System.out.format("USPS OOB error rate = %.2f%%%n", 100.0 * forest.error());
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            double[] accuracy = forest.test(testx, testy);
            for (int i3 = 1; i3 <= accuracy.length; ++i3) {
                System.out.format("%d trees accuracy = %.2f%%%n", i3, 100.0 * accuracy[i3 - 1]);
            }
            double[] importance = forest.importance();
            int[] index = QuickSort.sort(importance);
            int i4 = importance.length;
            while (i4-- > 0) {
                System.out.format("%s importance is %.4f%n", train.attributes()[index[i4]], importance[i4]);
            }
            System.out.println("USPS Nominal error = " + error);
            System.out.format("USPS Nominal OOB error rate = %.2f%%%n", 100.0 * forest.error());
            System.out.format("USPS Nominal error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
            Assert.assertTrue(error <= 250);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

