/*
 * Decompiled with CFR 0.152.
 */
package smile.classification;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.classification.NeuralNetwork;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.ArffParser;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.math.Math;
import smile.validation.LOOCV;

public class NeuralNetworkTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testIris() {
        System.out.println("Iris");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            int n = x.length;
            int p = x[0].length;
            double[] mu = Math.colMeans(x);
            double[] sd = Math.colSds(x);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < p; ++j) {
                    x[i][j] = (x[i][j] - mu[j]) / sd[j];
                }
            }
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                NeuralNetwork net = new NeuralNetwork(NeuralNetwork.ErrorFunction.CROSS_ENTROPY, NeuralNetwork.ActivationFunction.SOFTMAX, x[0].length, 10, 3);
                for (int j = 0; j < 20; ++j) {
                    net.learn(trainx, trainy);
                }
                if (y[loocv.test[i]] == net.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Neural network error = " + error);
            Assert.assertTrue(error <= 8);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testIris2() {
        System.out.println("Iris binary");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            for (int i = 0; i < y.length; ++i) {
                y[i] = y[i] == 2 ? 1 : 0;
            }
            int n = x.length;
            int p = x[0].length;
            double[] mu = Math.colMeans(x);
            double[] sd = Math.colSds(x);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < p; ++j) {
                    x[i][j] = (x[i][j] - mu[j]) / sd[j];
                }
            }
            LOOCV loocv = new LOOCV(n);
            int error = 0;
            for (int i = 0; i < n; ++i) {
                double[][] trainx = (double[][])Math.slice(x, loocv.train[i]);
                int[] trainy = Math.slice(y, loocv.train[i]);
                NeuralNetwork net = new NeuralNetwork(NeuralNetwork.ErrorFunction.CROSS_ENTROPY, NeuralNetwork.ActivationFunction.LOGISTIC_SIGMOID, x[0].length, 10, 1);
                for (int j = 0; j < 30; ++j) {
                    net.learn(trainx, trainy);
                }
                if (y[loocv.test[i]] == net.predict(x[loocv.test[i]])) continue;
                ++error;
            }
            System.out.println("Neural network error = " + error);
            Assert.assertTrue(error <= 8);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testSegment() {
        System.out.println("Segment");
        ArffParser parser = new ArffParser();
        parser.setResponseIndex(19);
        try {
            int j;
            int i;
            AttributeDataset train = parser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = parser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            double[][] x = (double[][])train.toArray((E[])new double[0][]);
            int[] y = train.toArray(new int[0]);
            double[][] testx = (double[][])test.toArray((E[])new double[0][]);
            int[] testy = test.toArray(new int[0]);
            int p = x[0].length;
            double[] mu = Math.colMin(x);
            double[] sd = Math.colMax(x);
            for (i = 0; i < x.length; ++i) {
                for (j = 0; j < p; ++j) {
                    x[i][j] = (x[i][j] - mu[j]) / sd[j];
                }
            }
            for (i = 0; i < testx.length; ++i) {
                for (j = 0; j < p; ++j) {
                    testx[i][j] = (testx[i][j] - mu[j]) / sd[j];
                }
            }
            NeuralNetwork net = new NeuralNetwork(NeuralNetwork.ErrorFunction.CROSS_ENTROPY, NeuralNetwork.ActivationFunction.SOFTMAX, x[0].length, 30, Math.max(y) + 1);
            for (j = 0; j < 20; ++j) {
                net.learn(x, y);
            }
            int error = 0;
            for (int i2 = 0; i2 < testx.length; ++i2) {
                if (net.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.format("Segment error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testSegmentLMS() {
        System.out.println("Segment LMS");
        ArffParser parser = new ArffParser();
        parser.setResponseIndex(19);
        try {
            int j;
            int i;
            AttributeDataset train = parser.parse(IOUtils.getTestDataFile("weka/segment-challenge.arff"));
            AttributeDataset test = parser.parse(IOUtils.getTestDataFile("weka/segment-test.arff"));
            double[][] x = (double[][])train.toArray((E[])new double[0][]);
            int[] y = train.toArray(new int[0]);
            double[][] testx = (double[][])test.toArray((E[])new double[0][]);
            int[] testy = test.toArray(new int[0]);
            int p = x[0].length;
            double[] mu = Math.colMin(x);
            double[] sd = Math.colMax(x);
            for (i = 0; i < x.length; ++i) {
                for (j = 0; j < p; ++j) {
                    x[i][j] = (x[i][j] - mu[j]) / sd[j];
                }
            }
            for (i = 0; i < testx.length; ++i) {
                for (j = 0; j < p; ++j) {
                    testx[i][j] = (testx[i][j] - mu[j]) / sd[j];
                }
            }
            NeuralNetwork net = new NeuralNetwork(NeuralNetwork.ErrorFunction.LEAST_MEAN_SQUARES, NeuralNetwork.ActivationFunction.LOGISTIC_SIGMOID, x[0].length, 30, Math.max(y) + 1);
            for (j = 0; j < 30; ++j) {
                net.learn(x, y);
            }
            int error = 0;
            for (int i2 = 0; i2 < testx.length; ++i2) {
                if (net.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.format("Segment error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            int j;
            int i;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            int p = x[0].length;
            double[] mu = Math.colMeans(x);
            double[] sd = Math.colSds(x);
            for (i = 0; i < x.length; ++i) {
                for (j = 0; j < p; ++j) {
                    x[i][j] = (x[i][j] - mu[j]) / sd[j];
                }
            }
            for (i = 0; i < testx.length; ++i) {
                for (j = 0; j < p; ++j) {
                    testx[i][j] = (testx[i][j] - mu[j]) / sd[j];
                }
            }
            NeuralNetwork net = new NeuralNetwork(NeuralNetwork.ErrorFunction.CROSS_ENTROPY, NeuralNetwork.ActivationFunction.SOFTMAX, x[0].length, 40, Math.max(y) + 1);
            for (j = 0; j < 30; ++j) {
                net.learn(x, y);
            }
            int error = 0;
            for (int i2 = 0; i2 < testx.length; ++i2) {
                if (net.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testUSPSLMS() {
        System.out.println("USPS LMS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            int j;
            int i;
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            int p = x[0].length;
            double[] mu = Math.colMeans(x);
            double[] sd = Math.colSds(x);
            for (i = 0; i < x.length; ++i) {
                for (j = 0; j < p; ++j) {
                    x[i][j] = (x[i][j] - mu[j]) / sd[j];
                }
            }
            for (i = 0; i < testx.length; ++i) {
                for (j = 0; j < p; ++j) {
                    testx[i][j] = (testx[i][j] - mu[j]) / sd[j];
                }
            }
            NeuralNetwork net = new NeuralNetwork(NeuralNetwork.ErrorFunction.LEAST_MEAN_SQUARES, NeuralNetwork.ActivationFunction.LOGISTIC_SIGMOID, x[0].length, 40, Math.max(y) + 1);
            for (j = 0; j < 30; ++j) {
                net.learn(x, y);
            }
            int error = 0;
            for (int i2 = 0; i2 < testx.length; ++i2) {
                if (net.predict(testx[i2]) == testy[i2]) continue;
                ++error;
            }
            System.out.format("USPS error rate = %.2f%%%n", 100.0 * (double)error / (double)testx.length);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

