/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SortedList<T extends Comparable<T>>
extends AbstractList<T> {
    private final List<T> elements;

    public SortedList(int initialCapacity) {
        this.elements = new ArrayList<T>(initialCapacity);
    }

    public SortedList(Collection<? extends T> c) {
        this(c.size());
        for (Comparable e : c) {
            this.add(e);
        }
    }

    public SortedList() {
        this(10);
    }

    @Override
    public T get(int index) {
        return (T)((Comparable)this.elements.get(index));
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean add(T e) {
        if (this.elements.isEmpty()) {
            this.elements.add(e);
            return true;
        }
        int index = Collections.binarySearch(this.elements, e);
        if (index < 0) {
            index = -index - 1;
        }
        this.elements.add(index, e);
        return true;
    }

    @Override
    public T remove(int index) {
        return (T)((Comparable)this.elements.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        try {
            return Collections.binarySearch(this.elements, (Comparable)o);
        }
        catch (NullPointerException e) {
            return -1;
        }
        catch (ClassCastException e) {
            return -1;
        }
    }
}

