/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import de.erichseifert.gral.util.SerializableArea;
import de.erichseifert.gral.util.SerializableBasicStroke;
import de.erichseifert.gral.util.SerializablePoint2D;
import de.erichseifert.gral.util.SerializableShape;
import de.erichseifert.gral.util.SerializationWrapper;
import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.io.Serializable;

public abstract class SerializationUtils {
    private SerializationUtils() {
        throw new UnsupportedOperationException();
    }

    public static Serializable wrap(Object o) {
        if (o == null || o instanceof Serializable) {
            return (Serializable)o;
        }
        if (o instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)o;
            return new SerializableBasicStroke(stroke);
        }
        if (o instanceof Point2D.Double || o instanceof Point2D.Float) {
            Point2D point = (Point2D)o;
            return new SerializablePoint2D(point);
        }
        if (o instanceof Area) {
            Area area = (Area)o;
            return new SerializableArea(area);
        }
        if (o instanceof Shape) {
            Shape shape = (Shape)o;
            return new SerializableShape(shape);
        }
        throw new IllegalArgumentException(String.format("Failed to make value of type %s serializable.", o.getClass().getName()));
    }

    public static Object unwrap(Serializable o) {
        if (o instanceof SerializationWrapper) {
            SerializationWrapper wrapper = (SerializationWrapper)o;
            return wrapper.unwrap();
        }
        return o;
    }
}

