/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.util.List;
import java.util.Random;

public abstract class MathUtils {
    private static final Random RANDOM = new Random();

    private MathUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean almostEqual(double a, double b, double delta) {
        return Math.abs(a - b) <= delta;
    }

    public static double round(double a, double precision) {
        if (precision == 0.0) {
            return 0.0;
        }
        return (double)Math.round(a / precision) * precision;
    }

    public static double floor(double a, double precision) {
        if (precision == 0.0) {
            return 0.0;
        }
        return Math.floor(a / precision) * precision;
    }

    public static double ceil(double a, double precision) {
        if (precision == 0.0) {
            return 0.0;
        }
        return Math.ceil(a / precision) * precision;
    }

    public static int binarySearch(double[] a, double key) {
        int i;
        int l = 0;
        int h = a.length - 1;
        do {
            if (key > a[i = (int)(((long)l + (long)h) / 2L)]) {
                l = i + 1;
                continue;
            }
            if (key < a[i]) {
                h = i - 1;
                continue;
            }
            return i;
        } while (l <= h);
        return i;
    }

    public static int binarySearchFloor(double[] a, double key) {
        if (a.length == 0) {
            return -1;
        }
        int i = MathUtils.binarySearch(a, key);
        if (i >= 0 && a[i] > key) {
            --i;
        }
        return i;
    }

    public static int binarySearchCeil(double[] a, double key) {
        if (a.length == 0) {
            return -1;
        }
        int i = MathUtils.binarySearch(a, key);
        if (i >= 0 && a[i] < key) {
            ++i;
        }
        return i;
    }

    public static <T extends Number> T limit(T value, T min, T max) {
        if (value.doubleValue() > max.doubleValue()) {
            return max;
        }
        if (value.doubleValue() < min.doubleValue()) {
            return min;
        }
        return value;
    }

    public static double limit(double value, double min, double max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static float limit(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static int limit(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    public static <T extends Comparable<T>> int randomizedSelect(List<T> a, int lower, int upper, int i) {
        if (a.isEmpty()) {
            return -1;
        }
        if (lower == upper) {
            return lower;
        }
        int pivot = MathUtils.randomizedPartition(a, lower, upper);
        int lowerPartitionElementCount = pivot - lower + 1;
        if (i == lowerPartitionElementCount) {
            return pivot;
        }
        if (i < lowerPartitionElementCount) {
            return MathUtils.randomizedSelect(a, lower, pivot - 1, i);
        }
        return MathUtils.randomizedSelect(a, pivot + 1, upper, i - lowerPartitionElementCount);
    }

    private static <T extends Comparable<T>> int randomizedPartition(List<T> a, int lower, int upper) {
        int i = lower + RANDOM.nextInt(upper - lower + 1);
        MathUtils.exchange(a, upper, i);
        return MathUtils.partition(a, lower, upper);
    }

    private static <T extends Comparable<T>> int partition(List<T> a, int lower, int upper) {
        Comparable x = (Comparable)a.get(upper);
        int i = lower - 1;
        for (int j = lower; j < upper; ++j) {
            if (((Comparable)a.get(j)).compareTo(x) > 0) continue;
            MathUtils.exchange(a, ++i, j);
        }
        MathUtils.exchange(a, i + 1, upper);
        return i + 1;
    }

    private static <T> void exchange(List<T> a, int i1, int i2) {
        T tmp = a.get(i2);
        a.set(i2, a.get(i1));
        a.set(i1, tmp);
    }

    public static double magnitude(double base, double n) {
        double logN = Math.log(Math.abs(n)) / Math.log(base);
        return Math.signum(n) * Math.pow(base, Math.floor(logN));
    }

    public static double quantile(List<Double> values, double q) {
        double a = 1.0;
        double b = -1.0;
        double c = 0.0;
        double d = 1.0;
        int n = values.size();
        double x = a + ((double)n + b) * q - 1.0;
        double xInt = (int)x;
        double xFrac = x - xInt;
        if (xInt < 0.0) {
            return values.get(0);
        }
        if (xInt >= (double)n) {
            return values.get(n - 1);
        }
        int i = (int)xInt;
        if (xFrac == 0.0) {
            return values.get(i);
        }
        return values.get(i) + (values.get(i + 1) - values.get(i)) * (c + d * xFrac);
    }

    public static boolean isCalculatable(Number n) {
        return n != null && MathUtils.isCalculatable(n.doubleValue());
    }

    public static boolean isCalculatable(double n) {
        return !Double.isNaN(n) && !Double.isInfinite(n);
    }

    public static double normalizeDegrees(double angle) {
        while (angle < 0.0) {
            angle += 360.0;
        }
        return angle % 360.0;
    }
}

