/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import de.erichseifert.gral.util.ConcatenationIterator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class Iterables {
    public static <T> Iterable<T> concatenate(Iterable<T> ... iterables) {
        return new ConcatenationIterable<T>(Arrays.asList(iterables));
    }

    public static <T> Iterable<T> take(final Iterable<T> iterable, final int elementCount) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LengthIterator(iterable.iterator(), elementCount);
            }
        };
    }

    private static class LengthIterator<T>
    implements Iterator<T> {
        private final Iterator<T> inputIterator;
        private final int maxElementCount;
        private int retrievedElementCount;

        public LengthIterator(Iterator<T> inputIterator, int elementCount) {
            this.inputIterator = inputIterator;
            this.maxElementCount = elementCount;
        }

        @Override
        public boolean hasNext() {
            return this.retrievedElementCount < this.maxElementCount && this.inputIterator.hasNext();
        }

        @Override
        public T next() {
            ++this.retrievedElementCount;
            return this.inputIterator.next();
        }

        @Override
        public void remove() {
            this.inputIterator.remove();
        }
    }

    private static class ConcatenationIterable<T>
    implements Iterable<T> {
        private final Iterable<Iterable<T>> inputIterables;

        public ConcatenationIterable(Iterable<Iterable<T>> inputIterables) {
            this.inputIterables = inputIterables;
        }

        @Override
        public Iterator<T> iterator() {
            LinkedList<Iterator<T>> iterators = new LinkedList<Iterator<T>>();
            for (Iterable<T> iterable : this.inputIterables) {
                iterators.add(iterable.iterator());
            }
            ConcatenationIterator iterator = new ConcatenationIterator(iterators.toArray(new Iterator[0]));
            return iterator;
        }
    }
}

