/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.util;

import java.io.Serializable;
import java.util.Iterator;

public class HaltonSequence
implements Iterator<Double>,
Serializable {
    private static final long serialVersionUID = 7466395251522942013L;
    private final int base;
    private long c;

    public HaltonSequence() {
        this(2);
    }

    public HaltonSequence(int base) {
        this.base = base;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public Double next() {
        if (++this.c == Long.MAX_VALUE) {
            this.c = 0L;
        }
        long i = this.c;
        double h = 0.0;
        double step = 1.0 / (double)this.base;
        while (i > 0L) {
            long digit = i % (long)this.base;
            h += (double)digit * step;
            i = (i - digit) / (long)this.base;
            step /= (double)this.base;
        }
        return h;
    }

    @Override
    public void remove() {
    }
}

