/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.ui;

import de.erichseifert.gral.graphics.Container;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.io.IOCapabilities;
import de.erichseifert.gral.io.plots.DrawableWriter;
import de.erichseifert.gral.io.plots.DrawableWriterFactory;
import de.erichseifert.gral.navigation.Navigable;
import de.erichseifert.gral.navigation.Navigator;
import de.erichseifert.gral.ui.DrawablePanel;
import de.erichseifert.gral.ui.DrawableWriterFilter;
import de.erichseifert.gral.ui.ExportChooser;
import de.erichseifert.gral.ui.ExportDialog;
import de.erichseifert.gral.util.Messages;
import de.erichseifert.gral.util.PointND;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class InteractivePanel
extends DrawablePanel
implements Printable {
    private static final long serialVersionUID = 9084883142053148090L;
    private static final double MM_TO_PT = 2.834645669291339;
    private static final double MM_PER_PX = 0.5669291338582678;
    private final PrinterJob printerJob = PrinterJob.getPrinterJob();
    private static final int MIN_DRAG = 0;
    private boolean zoomable;
    private boolean pannable;
    protected final ActionMap actions;
    private JPopupMenu popupMenu;
    private boolean popupMenuEnabled;
    private Point2D popupMenuPos;
    private final JFileChooser exportImageChooser;
    private MouseZoomListener zoomListener;
    private NavigationMoveListener panListener;

    public InteractivePanel(Drawable drawable) {
        super(drawable);
        this.printerJob.setPrintable(this);
        List<IOCapabilities> exportFormats = DrawableWriterFactory.getInstance().getCapabilities();
        this.exportImageChooser = new ExportChooser(true, exportFormats);
        this.exportImageChooser.setDialogTitle(Messages.getString("InteractivePanel.exportImageTitle"));
        this.actions = new ActionMap();
        this.actions.put("zoomIn", new AbstractAction(Messages.getString("InteractivePanel.zoomIn")){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractivePanel.this.zoom(InteractivePanel.this.popupMenuPos, 1);
            }
        });
        this.actions.put("zoomOut", new AbstractAction(Messages.getString("InteractivePanel.zoomOut")){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractivePanel.this.zoom(InteractivePanel.this.popupMenuPos, -1);
            }
        });
        this.actions.put("resetView", new AbstractAction(Messages.getString("InteractivePanel.resetView")){

            @Override
            public void actionPerformed(ActionEvent e) {
                InteractivePanel.this.resetZoom(InteractivePanel.this.popupMenuPos);
            }
        });
        this.actions.put("exportImage", new AbstractAction(Messages.getString("InteractivePanel.exportImage")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = InteractivePanel.this.exportImageChooser.showSaveDialog(InteractivePanel.this);
                InteractivePanel.this.repaint();
                if (ret != 0) {
                    return;
                }
                File file = InteractivePanel.this.exportImageChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                if (file.exists()) {
                    int retOverwrite = JOptionPane.showConfirmDialog(InteractivePanel.this, Messages.getString("InteractivePanel.exportExistsWarning"), Messages.getString("InteractivePanel.warning"), 0);
                    InteractivePanel.this.repaint();
                    if (retOverwrite == 1) {
                        return;
                    }
                }
                Drawable d = InteractivePanel.this.getDrawable();
                ExportDialog ed = new ExportDialog(InteractivePanel.this, d);
                ed.setVisible(true);
                if (!ed.getUserAction().equals((Object)ExportDialog.UserAction.APPROVE)) {
                    return;
                }
                DrawableWriterFilter filter = (DrawableWriterFilter)InteractivePanel.this.exportImageChooser.getFileFilter();
                InteractivePanel.this.export(d, filter.getWriterCapabilities().getMimeType(), file, ed.getDocumentBounds());
            }
        });
        this.actions.put("print", new AbstractAction(Messages.getString("InteractivePanel.print")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InteractivePanel.this.printerJob.printDialog()) {
                    try {
                        InteractivePanel.this.printerJob.print();
                    }
                    catch (PrinterException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.popupMenuEnabled = true;
        this.addMouseListener(new PopupListener());
        this.setZoomable(true);
        this.setPannable(true);
    }

    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(this.actions.get("zoomIn"));
            this.popupMenu.add(this.actions.get("zoomOut"));
            this.popupMenu.add(this.actions.get("resetView"));
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.actions.get("exportImage"));
            this.popupMenu.add(this.actions.get("print"));
        }
        return this.popupMenu;
    }

    public boolean isPopupMenuEnabled() {
        return this.popupMenuEnabled;
    }

    public void setPopupMenuEnabled(boolean popupMenuEnabled) {
        this.popupMenuEnabled = popupMenuEnabled;
    }

    private void zoom(Point2D point, int times) {
        if (!this.isZoomable()) {
            return;
        }
        Navigable navigable = InteractivePanel.getNavigableAt(this.getDrawable(), point);
        if (navigable == null) {
            return;
        }
        Navigator navigator = navigable.getNavigator();
        if (times >= 0) {
            for (int i = 0; i < times; ++i) {
                navigator.zoomIn();
            }
        } else {
            for (int i = 0; i < -times; ++i) {
                navigator.zoomOut();
            }
        }
        this.repaint();
    }

    private void resetZoom(Point2D point) {
        if (!this.isZoomable()) {
            return;
        }
        Navigable navigable = InteractivePanel.getNavigableAt(this.getDrawable(), point);
        if (navigable == null) {
            return;
        }
        Navigator navigator = navigable.getNavigator();
        navigator.reset();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export(Drawable component, String mimeType, File file, Rectangle2D documentBounds) {
        FileOutputStream destination;
        try {
            destination = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return;
        }
        DrawableWriter writer = DrawableWriterFactory.getInstance().get(mimeType);
        try {
            writer.write(component, destination, documentBounds.getX(), documentBounds.getY(), documentBounds.getWidth(), documentBounds.getHeight());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                destination.close();
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D graphics = (Graphics2D)g;
        AffineTransform txOld = graphics.getTransform();
        graphics.scale(0.5669291338582678, 0.5669291338582678);
        Rectangle2D boundsOld = this.getDrawable().getBounds();
        Rectangle2D.Double pageBounds = new Rectangle2D.Double(pageFormat.getImageableX() / 0.5669291338582678, pageFormat.getImageableY() / 0.5669291338582678, pageFormat.getImageableWidth() / 0.5669291338582678, pageFormat.getImageableHeight() / 0.5669291338582678);
        this.getDrawable().setBounds(pageBounds);
        try {
            this.getDrawable().draw(new DrawingContext(graphics));
        }
        finally {
            this.getDrawable().setBounds(boundsOld);
        }
        graphics.setTransform(txOld);
        return 0;
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean zoomable) {
        if (this.zoomable == zoomable) {
            return;
        }
        this.zoomable = zoomable;
        if (this.zoomListener != null) {
            this.removeMouseWheelListener(this.zoomListener);
            this.removeMouseListener(this.zoomListener);
            this.zoomListener = null;
        }
        if (zoomable) {
            this.zoomListener = new MouseZoomListener(this);
            this.addMouseListener(this.zoomListener);
            this.addMouseWheelListener(this.zoomListener);
        }
        this.actions.get("zoomIn").setEnabled(this.isZoomable());
        this.actions.get("zoomOut").setEnabled(this.isZoomable());
        this.actions.get("resetView").setEnabled(this.isZoomable() && this.isPannable());
    }

    public boolean isPannable() {
        return this.pannable;
    }

    public void setPannable(boolean pannable) {
        if (this.pannable == pannable) {
            return;
        }
        this.pannable = pannable;
        if (this.panListener != null) {
            this.removeMouseMotionListener(this.panListener);
            this.removeMouseListener(this.panListener);
            this.panListener = null;
        }
        if (pannable) {
            this.panListener = new NavigationMoveListener(this);
            this.addMouseListener(this.panListener);
            this.addMouseMotionListener(this.panListener);
        }
        this.actions.get("resetView").setEnabled(this.isZoomable() && this.isPannable());
    }

    private static Navigable getNavigableAt(Drawable drawable, Point2D point) {
        List<Drawable> componentsToCheck;
        if (drawable instanceof Container) {
            componentsToCheck = ((Container)((Object)drawable)).getDrawablesAt(point);
        } else {
            componentsToCheck = new ArrayList<Drawable>(1);
            componentsToCheck.add(drawable);
        }
        for (Drawable component : componentsToCheck) {
            if (!(component instanceof Navigable) || !component.getBounds().contains(point)) continue;
            return (Navigable)((Object)component);
        }
        return null;
    }

    private static class NavigationMoveListener
    extends MouseAdapter {
        private final InteractivePanel panel;
        private Navigable navigable;
        private Point posPrev;

        public NavigationMoveListener(InteractivePanel panel) {
            this.panel = panel;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            this.navigable = InteractivePanel.getNavigableAt(this.panel.getDrawable(), point);
            this.posPrev = point;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.navigable == null) {
                return;
            }
            Point pos = e.getPoint();
            Navigator navigator = this.navigable.getNavigator();
            int dx = pos.x - this.posPrev.x;
            int dy = pos.y - this.posPrev.y;
            this.posPrev = pos;
            if (Math.abs(dx) > 0 || Math.abs(dy) > 0) {
                PointND deltas = new PointND((Number[])new Integer[]{dx, dy});
                navigator.pan(deltas);
                this.panel.repaint();
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (!InteractivePanel.this.isPopupMenuEnabled() || !e.isPopupTrigger()) {
                return;
            }
            JPopupMenu menu = InteractivePanel.this.getPopupMenu(e);
            if (menu == null) {
                return;
            }
            InteractivePanel.this.popupMenuPos = e.getPoint();
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private static final class MouseZoomListener
    extends MouseAdapter
    implements MouseWheelListener,
    Serializable {
        private static final long serialVersionUID = -7323541053291673122L;
        private final InteractivePanel panel;

        public MouseZoomListener(InteractivePanel panel) {
            this.panel = panel;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            Point point = e.getPoint();
            this.panel.zoom(point, -e.getWheelRotation());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                Point point = e.getPoint();
                this.panel.zoom(point, 1);
            }
        }
    }
}

