/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.ui;

import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ExportDialog
extends JDialog {
    private static final long serialVersionUID = -1344719157074981540L;
    private final Rectangle2D documentBounds;
    private UserAction userAction;
    private final JFormattedTextField inputX;
    private final JFormattedTextField inputY;
    private final JFormattedTextField inputW;
    private final JFormattedTextField inputH;

    public ExportDialog(Component parent, Drawable drawable) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.setTitle(Messages.getString("ExportDialog.exportOptionsTitle"));
        this.documentBounds = new Rectangle2D.Double();
        this.documentBounds.setFrame(drawable.getBounds());
        this.setUserAction(UserAction.CANCEL);
        JPanel cp = new JPanel(new BorderLayout());
        cp.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(cp);
        DecimalFormat formatMm = new DecimalFormat();
        formatMm.setMinimumFractionDigits(2);
        JPanel options = new JPanel(new GridLayout(4, 2, 10, 2));
        this.getContentPane().add((Component)options, "North");
        PropertyChangeListener docBoundsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ExportDialog.this.setDocumentBounds(((Number)ExportDialog.this.inputX.getValue()).doubleValue(), ((Number)ExportDialog.this.inputY.getValue()).doubleValue(), ((Number)ExportDialog.this.inputW.getValue()).doubleValue(), ((Number)ExportDialog.this.inputH.getValue()).doubleValue());
            }
        };
        this.inputX = new JFormattedTextField(formatMm);
        ExportDialog.addInputField(this.inputX, Messages.getString("ExportDialog.left"), options, this.documentBounds.getX(), docBoundsListener);
        this.inputY = new JFormattedTextField(formatMm);
        ExportDialog.addInputField(this.inputY, Messages.getString("ExportDialog.top"), options, this.documentBounds.getY(), docBoundsListener);
        this.inputW = new JFormattedTextField(formatMm);
        ExportDialog.addInputField(this.inputW, Messages.getString("ExportDialog.width"), options, this.documentBounds.getWidth(), docBoundsListener);
        this.inputH = new JFormattedTextField(formatMm);
        ExportDialog.addInputField(this.inputH, Messages.getString("ExportDialog.height"), options, this.documentBounds.getHeight(), docBoundsListener);
        JPanel controls = new JPanel(new FlowLayout());
        cp.add((Component)controls, "South");
        JButton buttonConfirm = new JButton(Messages.getString("ExportDialog.confirm"));
        buttonConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.setUserAction(UserAction.APPROVE);
                ExportDialog.this.dispose();
            }
        });
        controls.add(buttonConfirm);
        JButton buttonCancel = new JButton(Messages.getString("ExportDialog.abort"));
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.setUserAction(UserAction.CANCEL);
                ExportDialog.this.dispose();
            }
        });
        controls.add(buttonCancel);
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    private static void addInputField(JFormattedTextField input, String labelText, Container cont, Object initialValue, PropertyChangeListener pcl) {
        JLabel label = new JLabel(labelText);
        label.setHorizontalAlignment(4);
        cont.add(label);
        input.setValue(initialValue);
        input.setHorizontalAlignment(4);
        input.addPropertyChangeListener("value", pcl);
        cont.add(input);
        label.setLabelFor(input);
    }

    public Rectangle2D getDocumentBounds() {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        bounds.setFrame(this.documentBounds);
        return bounds;
    }

    protected void setDocumentBounds(double x, double y, double w, double h) {
        if (this.documentBounds.getX() == x && this.documentBounds.getY() == y && this.documentBounds.getWidth() == w && this.documentBounds.getHeight() == h) {
            return;
        }
        this.documentBounds.setFrame(x, y, w, h);
        this.inputX.setValue(x);
        this.inputY.setValue(y);
        this.inputW.setValue(w);
        this.inputH.setValue(h);
    }

    public UserAction getUserAction() {
        return this.userAction;
    }

    private void setUserAction(UserAction userAction) {
        this.userAction = userAction;
    }

    public static enum UserAction {
        APPROVE,
        CANCEL;

    }
}

