/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.lines;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Orientation;
import de.erichseifert.gral.plots.DataPoint;
import de.erichseifert.gral.plots.lines.AbstractLineRenderer2D;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.List;

public class DiscreteLineRenderer2D
extends AbstractLineRenderer2D {
    private static final long serialVersionUID = 4648286099838467355L;
    private Orientation ascentDirection = Orientation.HORIZONTAL;
    private Number ascendingPoint = 0.5;

    @Override
    public Drawable getLine(List<DataPoint> points, final Shape shape) {
        AbstractDrawable d = new AbstractDrawable(){
            private static final long serialVersionUID = -1686744943386843195L;

            @Override
            public void draw(DrawingContext context) {
                Paint paint = DiscreteLineRenderer2D.this.getColor();
                GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, paint, null);
            }
        };
        return d;
    }

    @Override
    public Shape getLineShape(List<DataPoint> points) {
        Orientation dir = this.getAscentDirection();
        double ascendingPoint = this.getAscendingPoint().doubleValue();
        Path2D.Double shape = new Path2D.Double();
        for (DataPoint point : points) {
            Point2D pos = point.position.getPoint2D();
            if (shape.getCurrentPoint() == null) {
                ((Path2D)shape).moveTo(pos.getX(), pos.getY());
                continue;
            }
            Point2D posPrev = shape.getCurrentPoint();
            if (dir == Orientation.HORIZONTAL) {
                double ascendingX = posPrev.getX() + (pos.getX() - posPrev.getX()) * ascendingPoint;
                ((Path2D)shape).lineTo(ascendingX, posPrev.getY());
                ((Path2D)shape).lineTo(ascendingX, pos.getY());
            } else {
                double ascendingY = posPrev.getY() + (pos.getY() - posPrev.getY()) * ascendingPoint;
                ((Path2D)shape).lineTo(posPrev.getX(), ascendingY);
                ((Path2D)shape).lineTo(pos.getX(), ascendingY);
            }
            ((Path2D)shape).lineTo(pos.getX(), pos.getY());
        }
        return this.stroke(shape);
    }

    public Orientation getAscentDirection() {
        return this.ascentDirection;
    }

    public void setAscentDirection(Orientation ascentDirection) {
        this.ascentDirection = ascentDirection;
    }

    public Number getAscendingPoint() {
        return this.ascendingPoint;
    }

    public void setAscendingPoint(Number ascendingPoint) {
        this.ascendingPoint = ascendingPoint;
    }
}

