/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots.colors;

import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ScaledContinuousColorMapper;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Paint;

public class HeatMap
extends ScaledContinuousColorMapper {
    private static final long serialVersionUID = -5398973874608239179L;
    private static final Color[] COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f)};

    @Override
    public Paint get(double value) {
        Double v = this.scale(value);
        if (!MathUtils.isCalculatable(v = this.applyMode(v, 0.0, 1.0))) {
            return null;
        }
        double x = v;
        double xInv = 1.0 - x;
        double xInv2 = xInv * xInv;
        double x2 = x * x;
        double[] coeffs = new double[]{xInv2 * xInv2, 4.0 * x * xInv2 * xInv, 6.0 * x2 * xInv2, 4.0 * x * x2 * xInv, x2 * x2};
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double a = 0.0;
        for (int i = 0; i < COLORS.length; ++i) {
            r += coeffs[i] * (double)COLORS[i].getRed();
            g += coeffs[i] * (double)COLORS[i].getGreen();
            b += coeffs[i] * (double)COLORS[i].getBlue();
            a += coeffs[i] * (double)COLORS[i].getAlpha();
        }
        return new Color((float)MathUtils.limit(r, 0.0, 255.0) / 255.0f, (float)MathUtils.limit(g, 0.0, 255.0) / 255.0f, (float)MathUtils.limit(b, 0.0, 255.0) / 255.0f, (float)MathUtils.limit(a, 0.0, 255.0) / 255.0f);
    }

    @Override
    public void setMode(ColorMapper.Mode mode) {
        super.setMode(mode);
    }
}

