/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Dimension2D;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ContinuousColorMapper;
import de.erichseifert.gral.plots.colors.Grayscale;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RasterPlot
extends XYPlot {
    private static final long serialVersionUID = 5844862286358250831L;
    private final Point2D offset = new Point2D.Double();
    private final Dimension2D distance = new Dimension2D.Double(1.0, 1.0);
    private ColorMapper colors = new Grayscale();

    public RasterPlot(DataSource data) {
        super(new DataSource[0]);
        ((XYPlot.XYPlotArea2D)this.getPlotArea()).setMajorGridX(false);
        ((XYPlot.XYPlotArea2D)this.getPlotArea()).setMajorGridY(false);
        this.getAxisRenderer("x").setIntersection(-1.7976931348623157E308);
        this.getAxisRenderer("y").setIntersection(-1.7976931348623157E308);
        this.add(data);
        this.autoscaleAxes();
    }

    @Override
    public void autoscaleAxis(String axisName) {
        if ("x".equals(axisName) || "y".equals(axisName)) {
            Axis axis;
            Dimension2D dist = this.getDistance();
            if (dist == null) {
                dist = new Dimension2D.Double(1.0, 1.0);
            }
            if ((axis = this.getAxis(axisName)) == null || !axis.isAutoscaled()) {
                return;
            }
            double min = this.getAxisMin(axisName);
            double max = this.getAxisMax(axisName);
            if ("x".equals(axisName)) {
                axis.setRange(min, max + dist.getWidth());
            } else if ("y".equals(axisName)) {
                axis.setRange(min - dist.getHeight(), max);
            }
        } else {
            super.autoscaleAxis(axisName);
        }
    }

    public static DataSource createRasterData(DataSource data) {
        if (data == null) {
            throw new NullPointerException("Cannot convert null data source.");
        }
        DataTable coordsValueData = new DataTable(Double.class, Double.class, Double.class);
        double min = ((Number)((Object)data.getRowStatistics("min").getColumnStatistics("min").get(0, 0))).doubleValue();
        double max = ((Number)((Object)data.getRowStatistics("max").getColumnStatistics("max").get(0, 0))).doubleValue();
        double range = max - min;
        int i = 0;
        for (Comparable cell : data) {
            int x = i % data.getColumnCount();
            int y = -i / data.getColumnCount();
            double v = Double.NaN;
            if (cell instanceof Number) {
                Number numericCell = (Number)((Object)cell);
                v = (numericCell.doubleValue() - min) / range;
            }
            coordsValueData.add(Double.valueOf(x), Double.valueOf(y), Double.valueOf(v));
            ++i;
        }
        return coordsValueData;
    }

    @Override
    public void add(int index, DataSource source, boolean visible) {
        if (this.getData().size() > 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        super.add(index, source, visible);
        this.setLineRenderers(source, null);
        this.setPointRenderers(source, new RasterRenderer(this), new PointRenderer[0]);
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public void setOffset(Point2D offset) {
        this.offset.setLocation(offset);
    }

    public Dimension2D getDistance() {
        return this.distance;
    }

    public void setDistance(Dimension2D distance) {
        this.distance.setSize(distance);
    }

    public ColorMapper getColors() {
        return this.colors;
    }

    public void setColors(ColorMapper colors) {
        this.colors = colors;
    }

    protected static class RasterRenderer
    extends AbstractPointRenderer {
        private static final long serialVersionUID = 1266585364126459761L;
        private final RasterPlot plot;
        private int xColumn;
        private int yColumn;
        private int valueColumn;

        public RasterRenderer(RasterPlot plot) {
            this.plot = plot;
            this.xColumn = 0;
            this.yColumn = 1;
            this.valueColumn = 2;
        }

        public int getXColumn() {
            return this.xColumn;
        }

        public void setXColumn(int columnIndex) {
            this.xColumn = columnIndex;
        }

        public int getYColumn() {
            return this.yColumn;
        }

        public void setYColumn(int columnIndex) {
            this.yColumn = columnIndex;
        }

        @Override
        public int getValueColumn() {
            return this.valueColumn;
        }

        @Override
        public void setValueColumn(int columnIndex) {
            this.valueColumn = columnIndex;
        }

        @Override
        public Drawable getPoint(final PointData data, final Shape shape) {
            return new AbstractDrawable(){
                private static final long serialVersionUID = -1136689797647794969L;

                @Override
                public void draw(DrawingContext context) {
                    Paint paint;
                    RasterRenderer renderer = this;
                    Axis axisX = data.axes.get(0);
                    Axis axisY = data.axes.get(1);
                    AxisRenderer axisXRenderer = data.axisRenderers.get(0);
                    AxisRenderer axisYRenderer = data.axisRenderers.get(1);
                    Row row = data.row;
                    int colX = renderer.getXColumn();
                    if (colX < 0 || colX >= row.size() || !row.isColumnNumeric(colX)) {
                        return;
                    }
                    int colY = renderer.getYColumn();
                    if (colY < 0 || colY >= row.size() || !row.isColumnNumeric(colY)) {
                        return;
                    }
                    int colValue = renderer.getValueColumn();
                    if (colValue < 0 || colValue >= row.size() || !row.isColumnNumeric(colValue)) {
                        return;
                    }
                    double valueX = ((Number)((Object)row.get(colX))).doubleValue();
                    double valueY = ((Number)((Object)row.get(colY))).doubleValue();
                    Number value = (Number)((Object)row.get(colValue));
                    double xMin = axisXRenderer.getPosition(axisX, valueX - 0.5, true, false).get(0);
                    double xMax = axisXRenderer.getPosition(axisX, valueX + 0.5, true, false).get(0);
                    double width = Math.abs(xMax - xMin) + 1.0;
                    double yMin = axisYRenderer.getPosition(axisY, valueY - 0.5, true, false).get(1);
                    double yMax = axisYRenderer.getPosition(axisY, valueY + 0.5, true, false).get(1);
                    double height = Math.abs(yMax - yMin) + 1.0;
                    Rectangle2D shapeBounds = shape.getBounds2D();
                    AffineTransform tx = new AffineTransform();
                    tx.scale(width / shapeBounds.getWidth(), height / shapeBounds.getHeight());
                    tx.translate(-shapeBounds.getMinX(), -shapeBounds.getMinY());
                    Shape pixel = tx.createTransformedShape(shape);
                    Graphics2D graphics = context.getGraphics();
                    ColorMapper colorMapper = plot.getColors();
                    if (colorMapper instanceof ContinuousColorMapper) {
                        paint = ((ContinuousColorMapper)colorMapper).get(value.doubleValue());
                    } else if (colorMapper != null) {
                        Integer index = value.intValue();
                        paint = colorMapper.get(index);
                    } else {
                        paint = Color.BLACK;
                    }
                    GraphicsUtils.fillPaintedShape(graphics, pixel, paint, pixel.getBounds2D());
                }
            };
        }

        @Override
        public Shape getPointShape(PointData data) {
            return this.getShape();
        }

        @Override
        public Drawable getValue(PointData data, Shape shape) {
            AbstractDrawable drawable = new AbstractDrawable(){
                private static final long serialVersionUID = -8402945980942955359L;

                @Override
                public void draw(DrawingContext context) {
                }
            };
            return drawable;
        }
    }
}

