/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.Column;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.colors.ContinuousColorMapper;
import de.erichseifert.gral.plots.colors.SingleColor;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.ValueLegend;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

public class BoxPlot
extends XYPlot {
    private static final long serialVersionUID = -3069831535208696337L;

    public BoxPlot(DataSource data) {
        super(new DataSource[0]);
        this.setLegend(new BoxPlotLegend(this));
        ((XYPlot.XYPlotArea2D)this.getPlotArea()).setMajorGridX(false);
        this.getAxisRenderer("x").setTickSpacing(1.0);
        this.getAxisRenderer("x").setMinorTicksVisible(false);
        this.getAxisRenderer("x").setIntersection(-1.7976931348623157E308);
        this.getAxisRenderer("y").setIntersection(-1.7976931348623157E308);
        this.add(data);
        this.autoscaleAxes();
    }

    public static DataSource createBoxData(DataSource data) {
        if (data == null) {
            throw new NullPointerException("Cannot extract statistics from null data source.");
        }
        DataTable stats = new DataTable(Integer.class, Double.class, Double.class, Double.class, Double.class, Double.class);
        for (int c = 0; c < data.getColumnCount(); ++c) {
            Column<?> col = data.getColumn(c);
            if (!col.isNumeric()) continue;
            stats.add(Integer.valueOf(c + 1), Double.valueOf(col.getStatistics("quantile50")), Double.valueOf(col.getStatistics("min")), Double.valueOf(col.getStatistics("quantile25")), Double.valueOf(col.getStatistics("quantile75")), Double.valueOf(col.getStatistics("max")));
        }
        return stats;
    }

    @Override
    public void add(int index, DataSource source, boolean visible) {
        if (this.getData().size() > 0) {
            throw new IllegalArgumentException("This plot type only supports a single data source.");
        }
        BoxWhiskerRenderer renderer = new BoxWhiskerRenderer();
        this.setPointRenderers(source, renderer, new PointRenderer[0]);
        super.add(index, source, visible);
        this.setLineRenderers(source, null);
        this.setPointRenderers(source, renderer, new PointRenderer[0]);
    }

    @Override
    public void autoscaleAxis(String axisName) {
        Axis axis;
        if (!"x".equals(axisName) && !"y".equals(axisName)) {
            super.autoscaleAxis(axisName);
        }
        if ((axis = this.getAxis(axisName)) == null || !axis.isAutoscaled()) {
            return;
        }
        List<DataSource> sources = this.getData();
        if (sources.isEmpty()) {
            return;
        }
        boolean isXAxis = "x".equals(axisName);
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (DataSource data : sources) {
            int maxColumnIndex;
            int minColumnIndex;
            BoxWhiskerRenderer pointRenderer = null;
            for (PointRenderer p : this.getPointRenderers(data)) {
                if (!(p instanceof BoxWhiskerRenderer)) continue;
                pointRenderer = (BoxWhiskerRenderer)p;
                break;
            }
            if (pointRenderer == null) continue;
            if (isXAxis) {
                minColumnIndex = pointRenderer.getPositionColumn();
                maxColumnIndex = pointRenderer.getPositionColumn();
            } else {
                minColumnIndex = pointRenderer.getBottomBarColumn();
                maxColumnIndex = pointRenderer.getTopBarColumn();
            }
            min = Math.min(min, data.getColumn(minColumnIndex).getStatistics("min"));
            max = Math.max(max, data.getColumn(maxColumnIndex).getStatistics("max"));
        }
        double spacing = isXAxis ? 0.5 : 0.05 * (max - min);
        axis.setRange(min - spacing, max + spacing);
    }

    private static class LegendSymbol
    extends AbstractLegend.AbstractSymbol {
        private final Row row;
        private final BoxWhiskerRenderer boxWhiskerRenderer;

        public LegendSymbol(Row row, BoxWhiskerRenderer boxWhiskerRenderer, Font font, Dimension2D symbolSize) {
            super(font, symbolSize);
            this.row = row;
            this.boxWhiskerRenderer = boxWhiskerRenderer;
        }

        @Override
        public void draw(DrawingContext context) {
            Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 0.0, this.getBounds().getWidth(), this.getBounds().getHeight());
            Graphics2D graphics = context.getGraphics();
            AffineTransform txOrig = graphics.getTransform();
            graphics.translate(this.getX(), this.getY());
            GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, this.boxWhiskerRenderer.getBoxBackground().get(this.row.getIndex()), null);
            GraphicsUtils.drawPaintedShape(context.getGraphics(), shape, this.boxWhiskerRenderer.getBoxBorderColor(), null, this.boxWhiskerRenderer.getBoxBorderStroke());
            graphics.setTransform(txOrig);
        }
    }

    public static class BoxPlotLegend
    extends ValueLegend {
        private static final long serialVersionUID = 1517792984459627757L;
        private final BoxPlot plot;

        public BoxPlotLegend(BoxPlot plot) {
            this.plot = plot;
        }

        @Override
        protected Drawable getSymbol(Row row) {
            return new LegendSymbol(row, (BoxWhiskerRenderer)this.plot.getPointRenderers(row.getSource()).get(0), this.plot.getFont(), this.plot.getLegend().getSymbolSize());
        }
    }

    public static class BoxWhiskerRenderer
    extends AbstractPointRenderer {
        private static final long serialVersionUID = 2944482729753981341L;
        private int positionColumn = 0;
        private int centerBarColumn = 1;
        private int bottomBarColumn = 2;
        private int boxBottomColumn = 3;
        private int boxTopColumn = 4;
        private int topBarColumn = 5;
        private double boxWidth = 0.75;
        private ColorMapper boxBackground = new SingleColor(Color.WHITE);
        private Paint boxBorderColor = Color.BLACK;
        private transient Stroke boxBorderStroke = new BasicStroke(1.0f);
        private Paint whiskerColor = Color.BLACK;
        private transient Stroke whiskerStroke = new BasicStroke(1.0f);
        private double barWidth = 0.75;
        private Paint centerBarColor = Color.BLACK;
        private transient Stroke centerBarStroke = new BasicStroke(2.0f, 0, 0);

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.boxBorderStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
            this.whiskerStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
            this.centerBarStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
        }

        private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
            out.defaultWriteObject();
            out.writeObject(SerializationUtils.wrap(this.boxBorderStroke));
            out.writeObject(SerializationUtils.wrap(this.whiskerStroke));
            out.writeObject(SerializationUtils.wrap(this.centerBarStroke));
        }

        public int getPositionColumn() {
            return this.positionColumn;
        }

        public void setPositionColumn(int columnIndex) {
            this.positionColumn = columnIndex;
        }

        public int getCenterBarColumn() {
            return this.centerBarColumn;
        }

        public void setCenterBarColumn(int columnIndex) {
            this.centerBarColumn = columnIndex;
        }

        public int getBottomBarColumn() {
            return this.bottomBarColumn;
        }

        public void setBottomBarColumn(int columnIndex) {
            this.bottomBarColumn = columnIndex;
        }

        public int getBoxBottomColumn() {
            return this.boxBottomColumn;
        }

        public void setColumnBoxBottom(int columnIndex) {
            this.boxBottomColumn = columnIndex;
        }

        public int getBoxTopColumn() {
            return this.boxTopColumn;
        }

        public void setBoxTopColumn(int columnIndex) {
            this.boxTopColumn = columnIndex;
        }

        public int getTopBarColumn() {
            return this.topBarColumn;
        }

        public void setTopBarColumn(int columnIndex) {
            this.topBarColumn = columnIndex;
        }

        public double getBoxWidth() {
            return this.boxWidth;
        }

        public void setBoxWidth(double boxWidth) {
            this.boxWidth = boxWidth;
        }

        public ColorMapper getBoxBackground() {
            return this.boxBackground;
        }

        public void setBoxBackground(ColorMapper color) {
            this.boxBackground = color;
        }

        public void setBoxBackground(Paint color) {
            this.setBoxBackground(new SingleColor(color));
        }

        public Paint getBoxBorderColor() {
            return this.boxBorderColor;
        }

        public void setBoxBorderColor(Paint color) {
            this.boxBorderColor = color;
        }

        public Stroke getBoxBorderStroke() {
            return this.boxBorderStroke;
        }

        public void setBoxBorderStroke(Stroke stroke) {
            this.boxBorderStroke = stroke;
        }

        public Paint getWhiskerColor() {
            return this.whiskerColor;
        }

        public void setWhiskerColor(Paint color) {
            this.whiskerColor = color;
        }

        public Stroke getWhiskerStroke() {
            return this.whiskerStroke;
        }

        public void setWhiskerStroke(Stroke stroke) {
            this.whiskerStroke = stroke;
        }

        public double getBarWidth() {
            return this.barWidth;
        }

        public void setBarWidth(double width) {
            this.barWidth = width;
        }

        public Paint getCenterBarColor() {
            return this.centerBarColor;
        }

        public void setCenterBarColor(Paint color) {
            this.centerBarColor = color;
        }

        public Stroke getCenterBarStroke() {
            return this.centerBarStroke;
        }

        public void setCenterBarStroke(Stroke stroke) {
            this.centerBarStroke = stroke;
        }

        @Override
        public Drawable getPoint(final PointData data, final Shape shape) {
            return new AbstractDrawable(){
                private static final long serialVersionUID = 2765031432328349977L;

                @Override
                public void draw(DrawingContext context) {
                    Paint paintBox;
                    Axis axisX = data.axes.get(0);
                    Axis axisY = data.axes.get(1);
                    AxisRenderer axisXRenderer = data.axisRenderers.get(0);
                    AxisRenderer axisYRenderer = data.axisRenderers.get(1);
                    Row row = data.row;
                    BoxWhiskerRenderer renderer = this;
                    int colPos = renderer.getPositionColumn();
                    int colBarCenter = renderer.getCenterBarColumn();
                    int colBarBottom = renderer.getBottomBarColumn();
                    int colBoxBottom = renderer.getBoxBottomColumn();
                    int colBoxTop = renderer.getBoxTopColumn();
                    int colBarTop = renderer.getTopBarColumn();
                    if (!(row.isColumnNumeric(colPos) && row.isColumnNumeric(colBarCenter) && row.isColumnNumeric(colBarBottom) && row.isColumnNumeric(colBoxBottom) && row.isColumnNumeric(colBoxTop) && row.isColumnNumeric(colBarTop))) {
                        return;
                    }
                    double valueX = ((Number)((Object)row.get(colPos))).doubleValue();
                    double valueYBarBottom = ((Number)((Object)row.get(colBarBottom))).doubleValue();
                    double valueYBoxBottom = ((Number)((Object)row.get(colBoxBottom))).doubleValue();
                    double valueYBarCenter = ((Number)((Object)row.get(colBarCenter))).doubleValue();
                    double valueYBoxTop = ((Number)((Object)row.get(colBoxTop))).doubleValue();
                    double valueYBarTop = ((Number)((Object)row.get(colBarTop))).doubleValue();
                    double boxWidthRel = this.getBoxWidth();
                    double boxAlign = 0.5;
                    double boxXMin = axisXRenderer.getPosition(axisX, valueX - boxWidthRel * boxAlign, true, false).get(0);
                    double boxX = axisXRenderer.getPosition(axisX, valueX, true, false).get(0);
                    double boxXMax = axisXRenderer.getPosition(axisX, valueX + boxWidthRel * boxAlign, true, false).get(0);
                    double barYbottom = axisYRenderer.getPosition(axisY, valueYBarBottom, true, false).get(1);
                    double boxYBottom = axisYRenderer.getPosition(axisY, valueYBoxBottom, true, false).get(1);
                    double barYCenter = axisYRenderer.getPosition(axisY, valueYBarCenter, true, false).get(1);
                    double boxYTop = axisYRenderer.getPosition(axisY, valueYBoxTop, true, false).get(1);
                    double barYTop = axisYRenderer.getPosition(axisY, valueYBarTop, true, false).get(1);
                    double boxWidth = Math.abs(boxXMax - boxXMin);
                    double barWidthRel = this.getBarWidth();
                    double barXMin = boxXMin + (1.0 - barWidthRel) * boxWidth / 2.0;
                    double barXMax = boxXMax - (1.0 - barWidthRel) * boxWidth / 2.0;
                    Rectangle2D.Double boxBounds = new Rectangle2D.Double(boxXMin - boxX, boxYTop - barYCenter, boxWidth, Math.abs(boxYTop - boxYBottom));
                    Rectangle2D shapeBounds = shape.getBounds2D();
                    AffineTransform tx = new AffineTransform();
                    tx.translate(((RectangularShape)boxBounds).getX(), ((RectangularShape)boxBounds).getY());
                    tx.scale(((RectangularShape)boxBounds).getWidth() / shapeBounds.getWidth(), ((RectangularShape)boxBounds).getHeight() / shapeBounds.getHeight());
                    tx.translate(-shapeBounds.getMinX(), -shapeBounds.getMinY());
                    Shape box = tx.createTransformedShape(shape);
                    Line2D.Double whiskerMax = new Line2D.Double(0.0, boxYTop - barYCenter, 0.0, barYTop - barYCenter);
                    Line2D.Double whiskerMin = new Line2D.Double(0.0, boxYBottom - barYCenter, 0.0, barYbottom - barYCenter);
                    Line2D.Double barMax = new Line2D.Double(barXMin - boxX, barYTop - barYCenter, barXMax - boxX, barYTop - barYCenter);
                    Line2D.Double barMin = new Line2D.Double(barXMin - boxX, barYbottom - barYCenter, barXMax - boxX, barYbottom - barYCenter);
                    Line2D.Double barCenter = new Line2D.Double(boxXMin - boxX, 0.0, boxXMax - boxX, 0.0);
                    Graphics2D graphics = context.getGraphics();
                    ColorMapper paintBoxMapper = this.getBoxBackground();
                    if (paintBoxMapper instanceof ContinuousColorMapper) {
                        paintBox = ((ContinuousColorMapper)paintBoxMapper).get(valueX);
                    } else {
                        int index = data.index;
                        paintBox = paintBoxMapper.get(index);
                    }
                    Paint paintStrokeBox = this.getBoxBorderColor();
                    Stroke strokeBox = this.getBoxBorderStroke();
                    Paint paintWhisker = this.getWhiskerColor();
                    Stroke strokeWhisker = this.getWhiskerStroke();
                    Paint paintBarCenter = this.getCenterBarColor();
                    Stroke strokeBarCenter = this.getCenterBarStroke();
                    GraphicsUtils.fillPaintedShape(graphics, box, paintBox, box.getBounds2D());
                    Paint paintOld = graphics.getPaint();
                    Stroke strokeOld = graphics.getStroke();
                    graphics.setPaint(paintWhisker);
                    graphics.setStroke(strokeWhisker);
                    graphics.draw(whiskerMax);
                    graphics.draw(whiskerMin);
                    graphics.setPaint(paintStrokeBox);
                    graphics.setStroke(strokeBox);
                    graphics.draw(box);
                    graphics.draw(barMax);
                    graphics.draw(barMin);
                    graphics.setPaint(paintBarCenter);
                    graphics.setStroke(strokeBarCenter);
                    graphics.draw(barCenter);
                    graphics.setStroke(strokeOld);
                    graphics.setPaint(paintOld);
                }
            };
        }

        @Override
        public Shape getPointShape(PointData data) {
            return this.getShape();
        }

        @Override
        public Drawable getValue(PointData data, Shape shape) {
            AbstractDrawable drawable = new AbstractDrawable(){
                private static final long serialVersionUID = 6788431763837737592L;

                @Override
                public void draw(DrawingContext context) {
                }
            };
            return drawable;
        }
    }
}

