/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.plots;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.Row;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Location;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.axes.Axis;
import de.erichseifert.gral.plots.axes.AxisRenderer;
import de.erichseifert.gral.plots.colors.ColorMapper;
import de.erichseifert.gral.plots.legends.AbstractLegend;
import de.erichseifert.gral.plots.legends.ValueLegend;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.SerializationUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;

public class BarPlot
extends XYPlot {
    private static final long serialVersionUID = 3177733647455649147L;
    private double barWidth;
    private double barHeightMin;
    private boolean paintAllBars;

    public BarPlot(DataSource ... data) {
        super(data);
        ((XYPlot.XYPlotArea2D)this.getPlotArea()).setMajorGridX(false);
        this.barWidth = 1.0;
        this.barHeightMin = 0.0;
        this.paintAllBars = false;
        BarPlotLegend legend = new BarPlotLegend(this);
        this.setLegend(legend);
        this.autoscaleAxes();
    }

    @Override
    public void autoscaleAxis(String axisName) {
        Axis axis;
        if (!"x".equals(axisName) && !"y".equals(axisName)) {
            super.autoscaleAxis(axisName);
        }
        if ((axis = this.getAxis(axisName)) == null || !axis.isAutoscaled()) {
            return;
        }
        List<DataSource> sources = this.getData();
        if (sources.isEmpty()) {
            return;
        }
        int rowCount = 0;
        for (DataSource data : sources) {
            rowCount = Math.max(rowCount, data.getRowCount());
        }
        if (rowCount == 0) {
            return;
        }
        double min = this.getAxisMin(axisName);
        double max = this.getAxisMax(axisName);
        double spacing = 0.0;
        if ("x".equals(axisName)) {
            double barWidth = this.getBarWidth();
            double margin = barWidth * (max - min) / (double)rowCount;
            spacing = margin / 2.0;
        } else {
            min = Math.min(min, 0.0);
            max = Math.max(max, 0.0);
        }
        axis.setRange(min - spacing, max + spacing);
    }

    @Override
    public void add(int index, DataSource source, boolean visible) {
        super.add(index, source, visible);
        BarRenderer pointRendererDefault = new BarRenderer(this);
        LineRenderer lineRendererDefault = null;
        AreaRenderer areaRendererDefault = null;
        this.setPointRenderers(source, pointRendererDefault, new PointRenderer[0]);
        this.setLineRenderers(source, lineRendererDefault, new LineRenderer[0]);
        this.setAreaRenderers(source, areaRendererDefault, new AreaRenderer[0]);
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(double barWidth) {
        this.barWidth = barWidth;
    }

    public double getBarHeightMin() {
        return this.barHeightMin;
    }

    public void setBarHeightMin(double barHeightMin) {
        this.barHeightMin = barHeightMin;
    }

    public boolean isPaintAllBars() {
        return this.paintAllBars;
    }

    public void setPaintAllBars(boolean paintAllBars) {
        this.paintAllBars = paintAllBars;
    }

    private static class LegendSymbol
    extends AbstractLegend.AbstractSymbol {
        private final Row row;
        private final BarRenderer barRenderer;

        public LegendSymbol(Row row, BarRenderer barRenderer, Font font, Dimension2D symbolSize) {
            super(font, symbolSize);
            this.row = row;
            this.barRenderer = barRenderer;
        }

        @Override
        public void draw(DrawingContext context) {
            double width = this.getPreferredSize().getWidth();
            double height = this.getPreferredSize().getHeight();
            Shape shape = this.barRenderer.getBarShape(0.0, 0.0, width, height);
            Graphics2D graphics = context.getGraphics();
            AffineTransform txOrig = graphics.getTransform();
            graphics.translate(this.getX(), this.getY());
            GraphicsUtils.fillPaintedShape(context.getGraphics(), shape, this.barRenderer.getColor().get(0), null);
            GraphicsUtils.drawPaintedShape(context.getGraphics(), shape, this.barRenderer.getBorderColor(), null, this.barRenderer.getBorderStroke());
            graphics.setTransform(txOrig);
        }
    }

    public static class BarPlotLegend
    extends ValueLegend {
        private static final long serialVersionUID = 4752278896167602641L;
        private final BarPlot plot;

        public BarPlotLegend(BarPlot plot) {
            this.plot = plot;
        }

        @Override
        protected Drawable getSymbol(Row row) {
            List<PointRenderer> pointRenderers = this.plot.getPointRenderers(row.getSource());
            BarRenderer barRenderer = (BarRenderer)pointRenderers.get(0);
            return new LegendSymbol(row, barRenderer, this.plot.getFont(), this.plot.getLegend().getSymbolSize());
        }
    }

    public static class BarRenderer
    extends DefaultPointRenderer2D {
        private static final long serialVersionUID = 2183638342305398522L;
        private final BarPlot plot;
        private transient Stroke borderStroke;
        private Paint borderColor;

        public BarRenderer(BarPlot plot) {
            this.plot = plot;
            this.setValueLocation(Location.NORTH);
            this.borderStroke = null;
            this.borderColor = Color.BLACK;
        }

        private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            in.defaultReadObject();
            this.borderStroke = (Stroke)SerializationUtils.unwrap((Serializable)in.readObject());
        }

        private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
            out.defaultWriteObject();
            out.writeObject(SerializationUtils.wrap(this.borderStroke));
        }

        public Stroke getBorderStroke() {
            return this.borderStroke;
        }

        public void setBorderStroke(Stroke stroke) {
            this.borderStroke = stroke;
        }

        public Paint getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(Paint color) {
            this.borderColor = color;
        }

        @Override
        public Drawable getPoint(final PointData data, final Shape shape) {
            return new AbstractDrawable(){
                private static final long serialVersionUID = -3145112034673683520L;

                @Override
                public void draw(DrawingContext context) {
                    BarRenderer renderer = this;
                    Rectangle2D.Double paintBoundaries = null;
                    Graphics2D graphics = context.getGraphics();
                    ColorMapper colors = renderer.getColor();
                    Paint paint = colors.get(data.index);
                    if (plot.isPaintAllBars()) {
                        AffineTransform txOld = graphics.getTransform();
                        Rectangle2D shapeBounds = shape.getBounds2D();
                        paintBoundaries = new Rectangle2D.Double();
                        paintBoundaries = new Rectangle2D.Double(shapeBounds.getX(), ((RectangularShape)paintBoundaries).getY() - txOld.getTranslateY(), shapeBounds.getWidth(), ((RectangularShape)paintBoundaries).getHeight());
                    }
                    GraphicsUtils.fillPaintedShape(graphics, shape, paint, paintBoundaries);
                    Stroke stroke = renderer.getBorderStroke();
                    Paint strokePaint = renderer.getBorderColor();
                    if (stroke != null && strokePaint != null) {
                        GraphicsUtils.drawPaintedShape(graphics, shape, strokePaint, null, stroke);
                    }
                }
            };
        }

        @Override
        public Shape getPointShape(PointData data) {
            int colX = 0;
            int colY = 1;
            Axis axisX = data.axes.get(0);
            Axis axisY = data.axes.get(1);
            AxisRenderer axisXRenderer = data.axisRenderers.get(0);
            AxisRenderer axisYRenderer = data.axisRenderers.get(1);
            Row row = data.row;
            if (!row.isColumnNumeric(colX) || !row.isColumnNumeric(colY)) {
                return null;
            }
            double valueX = ((Number)((Object)row.get(colX))).doubleValue();
            double valueY = ((Number)((Object)row.get(colY))).doubleValue();
            double axisYOrigin = 0.0;
            double barWidthRel = this.plot.getBarWidth();
            barWidthRel = Math.max(barWidthRel, 0.0);
            double barAlign = 0.5;
            double barXMin = axisXRenderer.getPosition(axisX, valueX - barWidthRel * barAlign, true, false).get(0);
            double barXMax = axisXRenderer.getPosition(axisX, valueX + barWidthRel * barAlign, true, false).get(0);
            double barYVal = axisYRenderer.getPosition(axisY, valueY, true, false).get(1);
            double barYOrigin = axisYRenderer.getPosition(axisY, axisYOrigin, true, false).get(1);
            double barYMin = Math.min(barYVal, barYOrigin);
            double barYMax = Math.max(barYVal, barYOrigin);
            double barWidth = Math.abs(barXMax - barXMin);
            double barHeight = Math.abs(barYMax - barYMin);
            double barX = axisXRenderer.getPosition(axisX, valueX, true, false).get(0);
            boolean barAboveAxis = barYMax == barYOrigin;
            double barY = barAboveAxis ? 0.0 : -barHeight;
            double barHeightMin = this.plot.getBarHeightMin();
            if (MathUtils.isCalculatable(barHeightMin) && barHeightMin > 0.0 && barHeight < barHeightMin) {
                if (barAboveAxis) {
                    barY += -barHeightMin + barHeight;
                }
                barHeight = barHeightMin;
            }
            Shape shape = this.getBarShape(barXMin - barX, barY, barWidth, barHeight);
            return shape;
        }

        protected Shape getBarShape(double x, double y, double width, double height) {
            Shape shape = this.getShape();
            Rectangle2D shapeBounds = shape.getBounds2D();
            AffineTransform tx = new AffineTransform();
            tx.translate(x, y);
            tx.scale(width / shapeBounds.getWidth(), height / shapeBounds.getHeight());
            tx.translate(-shapeBounds.getMinX(), -shapeBounds.getMinY());
            Shape shapeTransformed = tx.createTransformedShape(shape);
            return shapeTransformed;
        }

        @Override
        public Drawable getValue(final PointData data, final Shape shape) {
            AbstractDrawable drawable = new AbstractDrawable(){
                private static final long serialVersionUID = -1133369168849171793L;

                @Override
                public void draw(DrawingContext context) {
                    BarRenderer renderer = this;
                    Row row = data.row;
                    if (renderer.isValueVisible()) {
                        int colValue = renderer.getValueColumn();
                        this.drawValueLabel(context, shape, row, data.index, colValue);
                    }
                }
            };
            return drawable;
        }
    }
}

