/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.graphics;

import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.util.GraphicsUtils;
import de.erichseifert.gral.util.MathUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;

public class Label
extends AbstractDrawable {
    private static final long serialVersionUID = 374045708533704103L;
    private String text;
    private double alignmentX;
    private double alignmentY;
    private Font font;
    private double rotation;
    private Paint color;
    private double textAlignment;
    private boolean wordWrapEnabled;
    private Paint background;
    private transient Shape outlineWrapped;
    private transient Shape outlineUnwrapped;

    public Label() {
        this("");
    }

    public Label(String text) {
        this.text = text;
        this.alignmentX = 0.5;
        this.alignmentY = 0.5;
        this.font = Font.decode(null);
        this.rotation = 0.0;
        this.color = Color.BLACK;
        this.textAlignment = 0.5;
        this.wordWrapEnabled = false;
    }

    @Override
    public void draw(DrawingContext context) {
        boolean wordWrap = this.isWordWrapEnabled();
        Shape labelShape = this.getCachedOutline(wordWrap);
        if (labelShape == null) {
            return;
        }
        Rectangle2D textBounds = labelShape.getBounds2D();
        double rotation = this.getRotation();
        if (MathUtils.isCalculatable(rotation) && rotation != 0.0) {
            AffineTransform txLabelText = AffineTransform.getRotateInstance(Math.toRadians(-rotation), textBounds.getCenterX(), textBounds.getCenterY());
            labelShape = txLabelText.createTransformedShape(labelShape);
            textBounds = labelShape.getBounds2D();
        }
        Graphics2D graphics = context.getGraphics();
        AffineTransform txOld = graphics.getTransform();
        Paint background = this.getBackground();
        if (background != null) {
            GraphicsUtils.fillPaintedShape(graphics, this.getBounds(), background, null);
        }
        double shapePosX = this.getX() - textBounds.getX();
        double shapePosY = this.getY() - textBounds.getY();
        double alignmentX = this.getAlignmentX();
        double alignmentY = this.getAlignmentY();
        graphics.translate(shapePosX += alignmentX * (this.getWidth() - textBounds.getWidth()), shapePosY += alignmentY * (this.getHeight() - textBounds.getHeight()));
        Paint paint = this.getColor();
        GraphicsUtils.fillPaintedShape(graphics, labelShape, paint, null);
        graphics.setTransform(txOld);
    }

    @Override
    public Dimension2D getPreferredSize() {
        Dimension2D d = super.getPreferredSize();
        if (this.getCachedOutline(false) != null) {
            Shape shape = this.getTextRectangle();
            Rectangle2D bounds = shape.getBounds2D();
            double rotation = this.getRotation();
            if (MathUtils.isCalculatable(rotation) && rotation != 0.0) {
                AffineTransform txLabelText = AffineTransform.getRotateInstance(Math.toRadians(-rotation), bounds.getCenterX(), bounds.getCenterY());
                shape = txLabelText.createTransformedShape(shape);
            }
            d.setSize(shape.getBounds2D().getWidth(), shape.getBounds2D().getHeight());
        }
        return d;
    }

    protected Shape getOutline(boolean wordWrap) {
        Font font = this.getFont();
        float wrappingWidth = 0.0f;
        if (wordWrap) {
            double rotation = Math.toRadians(this.getRotation());
            wrappingWidth = (float)(Math.abs(Math.cos(rotation)) * this.getWidth() + Math.abs(Math.sin(rotation)) * this.getHeight());
        }
        double alignment = this.getTextAlignment();
        Shape outline = GraphicsUtils.getOutline(this.getText(), font, wrappingWidth, alignment);
        return outline;
    }

    protected Shape getCachedOutline(boolean wordWrap) {
        if (!this.isValid() && this.getText() != null && !this.getText().isEmpty()) {
            this.outlineWrapped = this.getOutline(true);
            this.outlineUnwrapped = this.getOutline(false);
        }
        if (wordWrap) {
            return this.outlineWrapped;
        }
        return this.outlineUnwrapped;
    }

    public Rectangle2D getTextRectangle() {
        return this.getCachedOutline(false).getBounds();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    protected void invalidate() {
        this.outlineWrapped = null;
        this.outlineUnwrapped = null;
    }

    protected boolean isValid() {
        boolean wordWrap = this.isWordWrapEnabled();
        if (wordWrap) {
            return this.outlineWrapped != null;
        }
        return this.outlineUnwrapped != null;
    }

    @Override
    public void setBounds(double x, double y, double width, double height) {
        double widthOld = this.getWidth();
        double heightOld = this.getHeight();
        super.setBounds(x, y, width, height);
        if (width != widthOld || height != heightOld) {
            this.invalidate();
        }
    }

    public double getAlignmentX() {
        return this.alignmentX;
    }

    public void setAlignmentX(double alignmentX) {
        this.alignmentX = alignmentX;
    }

    public double getAlignmentY() {
        return this.alignmentY;
    }

    public void setAlignmentY(double alignmentY) {
        this.alignmentY = alignmentY;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidate();
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double angle) {
        this.rotation = angle;
        this.invalidate();
    }

    public Paint getColor() {
        return this.color;
    }

    public void setColor(Paint color) {
        this.color = color;
    }

    public double getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(double textAlignment) {
        this.textAlignment = textAlignment;
        this.invalidate();
    }

    public boolean isWordWrapEnabled() {
        return this.wordWrapEnabled;
    }

    public void setWordWrapEnabled(boolean wordWrapEnabled) {
        this.wordWrapEnabled = wordWrapEnabled;
        this.invalidate();
    }

    public Paint getBackground() {
        return this.background;
    }

    public void setBackground(Paint background) {
        this.background = background;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Label)) {
            return false;
        }
        Label label = (Label)obj;
        return (this.getText() == null && label.getText() == null || this.getText().equals(label.getText())) && this.getAlignmentX() == label.getAlignmentX() && this.getAlignmentY() == label.getAlignmentY() && (this.getFont() == null && label.getFont() == null || this.getFont().equals(label.getFont())) && this.getRotation() == label.getRotation() && (this.getColor() == null && label.getColor() == null || this.getColor().equals(label.getColor())) && this.getTextAlignment() == label.getTextAlignment() && this.isWordWrapEnabled() == label.isWordWrapEnabled() && (this.getBackground() == null && label.getBackground() == null || this.getBackground().equals(label.getBackground()));
    }
}

