/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataSeries;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.plots.points.SizeablePointRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Ellipse2D;

public class SpiralPlot
extends ExamplePanel {
    private static final long serialVersionUID = 995084910079463763L;

    public SpiralPlot() {
        this.setPreferredSize(new Dimension(600, 600));
        DataTable data = new DataTable(Double.class, Double.class, Double.class);
        double alpha = 0.0;
        for (double r = 0.0; r <= 10.0; r += 0.05) {
            double x = r * Math.cos(alpha);
            double y = r * Math.sin(alpha);
            double z = 3.0 + 4.0 * r;
            data.add(Double.valueOf(x), Double.valueOf(y), Double.valueOf(z));
            alpha -= 1.0;
        }
        DataSeries series = new DataSeries("Spiral", data, new int[0]);
        XYPlot plot = new XYPlot(series);
        plot.setInsets(new Insets2D.Double(40.0));
        plot.setBackground(new Color(0.75f, 0.75f, 0.75f));
        XYPlot.XYPlotArea2D plotArea = (XYPlot.XYPlotArea2D)plot.getPlotArea();
        plotArea.setBorderColor(null);
        plotArea.setMajorGridX(false);
        plotArea.setMajorGridY(false);
        plotArea.setClippingArea(null);
        plot.getAxisRenderer("x").setShapeVisible(false);
        plot.getAxisRenderer("x").setTicksVisible(false);
        plot.getAxisRenderer("y").setShapeVisible(false);
        plot.getAxisRenderer("y").setTicksVisible(false);
        plot.getAxis("x").setRange(-10.0, 10.0);
        plot.getAxis("y").setRange(-10.0, 10.0);
        Color color = GraphicsUtils.deriveWithAlpha(COLOR1, 96);
        SizeablePointRenderer pointRenderer = new SizeablePointRenderer();
        pointRenderer.setShape(new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0));
        pointRenderer.setColor(color);
        pointRenderer.setColumn(2);
        plot.setPointRenderers(series, pointRenderer, new PointRenderer[0]);
        this.add((Component)new InteractivePanel(plot), "Center");
    }

    @Override
    public String getTitle() {
        return "Spiral bubble plot";
    }

    @Override
    public String getDescription() {
        return "Bubble plot showing data points in a spiral-like shape";
    }

    public static void main(String[] args) {
        new SpiralPlot().showInFrame();
    }
}

