/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.AbstractDrawable;
import de.erichseifert.gral.graphics.Drawable;
import de.erichseifert.gral.graphics.DrawingContext;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.AbstractPointRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointData;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class MultiplePointRenderers
extends ExamplePanel {
    private static final long serialVersionUID = -5263057758564264677L;

    public MultiplePointRenderers() {
        DataTable data = new DataTable(Double.class, Double.class);
        for (double x = 1.0; x <= 20.0; x += 1.0) {
            data.add(Double.valueOf(x), Double.valueOf(x * x));
        }
        XYPlot plot = new XYPlot(data);
        plot.setInsets(new Insets2D.Double(20.0, 60.0, 40.0, 40.0));
        plot.setBackground(Color.WHITE);
        plot.getTitle().setText(this.getDescription());
        DefaultPointRenderer2D defaultPointRenderer = new DefaultPointRenderer2D();
        defaultPointRenderer.setColor(GraphicsUtils.deriveDarker(COLOR1));
        plot.setPointRenderers(data, defaultPointRenderer, new PointRenderer[0]);
        ShadowPointRenderer shadowRenderer = new ShadowPointRenderer(defaultPointRenderer);
        plot.addPointRenderer(data, shadowRenderer);
        DefaultLineRenderer2D lineRenderer = new DefaultLineRenderer2D();
        lineRenderer.setGap(2.0);
        plot.setLineRenderers(data, lineRenderer, new LineRenderer[0]);
        this.add((Component)new InteractivePanel(plot), "Center");
    }

    @Override
    public String getTitle() {
        return "Multiple renderers";
    }

    @Override
    public String getDescription() {
        return "Plot with point shadows";
    }

    public static void main(String[] args) {
        new MultiplePointRenderers().showInFrame();
    }

    private static class ShadowPointRenderer
    extends AbstractPointRenderer {
        private final PointRenderer pointRenderer;

        public ShadowPointRenderer(PointRenderer pointRenderer) {
            this.pointRenderer = pointRenderer;
        }

        @Override
        public Shape getPointShape(PointData data) {
            return this.pointRenderer.getPointShape(data);
        }

        @Override
        public Drawable getPoint(PointData data, final Shape shape) {
            AbstractDrawable drawable = new AbstractDrawable(){

                @Override
                public void draw(DrawingContext context) {
                    Graphics2D graphics2D = context.getGraphics();
                    AffineTransform txOld = graphics2D.getTransform();
                    graphics2D.translate(2.0, 1.0);
                    GraphicsUtils.fillPaintedShape(graphics2D, shape, new Color(0.0f, 0.0f, 0.0f, 0.2f), null);
                    graphics2D.setTransform(txOld);
                }
            };
            return drawable;
        }

        @Override
        public Drawable getValue(PointData data, Shape shape) {
            return this.pointRenderer.getValue(data, shape);
        }
    }
}

