/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.xyplot;

import de.erichseifert.gral.data.DataSeries;
import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.XYPlot;
import de.erichseifert.gral.plots.areas.AreaRenderer;
import de.erichseifert.gral.plots.areas.DefaultAreaRenderer2D;
import de.erichseifert.gral.plots.areas.LineAreaRenderer2D;
import de.erichseifert.gral.plots.lines.DefaultLineRenderer2D;
import de.erichseifert.gral.plots.lines.LineRenderer;
import de.erichseifert.gral.plots.points.DefaultPointRenderer2D;
import de.erichseifert.gral.plots.points.PointRenderer;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.util.Random;

public class AreaPlot
extends ExamplePanel {
    private static final long serialVersionUID = 3287044991898775949L;
    private static final Random random = new Random();

    public AreaPlot() {
        DataTable data = new DataTable(Double.class, Double.class, Double.class, Double.class);
        for (double x = 0.0; x < 7.853981633974483; x += 0.20943951023931953) {
            double y1 = Double.NaN;
            double y2 = Double.NaN;
            double y3 = Double.NaN;
            if (x >= 0.0 && x < 7.0685834705770345) {
                y1 = 4.0 * Math.sin(x + 1.5707963267948966) + 0.1 * random.nextGaussian();
            }
            if (x >= 0.7853981633974483 && x < 7.853981633974483) {
                y2 = 4.0 * Math.cos(x + 1.5707963267948966) + 0.1 * random.nextGaussian();
            }
            if (x >= 0.0 && x < 7.853981633974483) {
                y3 = 2.0 * Math.sin(2.0 * x / 2.5) + 0.1 * random.nextGaussian();
            }
            data.add(Double.valueOf(x), Double.valueOf(y1), Double.valueOf(y2), Double.valueOf(y3));
        }
        DataSeries data1 = new DataSeries("red", data, 0, 1);
        DataSeries data2 = new DataSeries("blue 1", data, 0, 2);
        DataSeries data3 = new DataSeries("blue 2", data, 0, 3);
        XYPlot plot = new XYPlot(data1, data2, data3);
        plot.setLegendVisible(true);
        plot.setInsets(new Insets2D.Double(20.0, 40.0, 20.0, 20.0));
        AreaPlot.formatFilledArea(plot, data1, COLOR2);
        AreaPlot.formatFilledArea(plot, data2, COLOR1);
        AreaPlot.formatLineArea(plot, data3, GraphicsUtils.deriveDarker(COLOR1));
        this.add(new InteractivePanel(plot));
    }

    private static void formatFilledArea(XYPlot plot, DataSource data, Color color) {
        DefaultPointRenderer2D point = new DefaultPointRenderer2D();
        point.setColor(color);
        plot.setPointRenderers(data, point, new PointRenderer[0]);
        DefaultLineRenderer2D line = new DefaultLineRenderer2D();
        line.setColor(color);
        line.setGap(3.0);
        line.setGapRounded(true);
        plot.setLineRenderers(data, line, new LineRenderer[0]);
        DefaultAreaRenderer2D area = new DefaultAreaRenderer2D();
        area.setColor(GraphicsUtils.deriveWithAlpha(color, 64));
        plot.setAreaRenderers(data, area, new AreaRenderer[0]);
    }

    private static void formatLineArea(XYPlot plot, DataSource data, Color color) {
        DefaultPointRenderer2D point = new DefaultPointRenderer2D();
        point.setColor(color);
        plot.setPointRenderers(data, point, new PointRenderer[0]);
        plot.setLineRenderers(data, null);
        LineAreaRenderer2D area = new LineAreaRenderer2D();
        area.setGap(3.0);
        area.setColor(color);
        plot.setAreaRenderers(data, area, new AreaRenderer[0]);
    }

    @Override
    public String getTitle() {
        return "Area plot";
    }

    @Override
    public String getDescription() {
        return "Area plot of three series with different styling";
    }

    public static void main(String[] args) {
        new AreaPlot().showInFrame();
    }
}

