/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.rasterplot;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.RasterPlot;
import de.erichseifert.gral.plots.colors.LinearGradient;
import de.erichseifert.gral.ui.InteractivePanel;
import de.erichseifert.gral.util.GraphicsUtils;
import java.awt.Color;
import java.awt.Dimension;

public class SimpleRasterPlot
extends ExamplePanel {
    private static final long serialVersionUID = -2515812178479580541L;
    private static final int SIZE = 64;
    private static final double ZOOM = 0.3;

    public SimpleRasterPlot() {
        this.setPreferredSize(new Dimension(600, 600));
        DataTable raster = new DataTable(64, Double.class);
        for (int rowIndex = 0; rowIndex < raster.getColumnCount(); ++rowIndex) {
            Comparable[] row = new Comparable[raster.getColumnCount()];
            double y = 0.3 * (double)rowIndex;
            for (int colIndex = 0; colIndex < row.length; ++colIndex) {
                double x = 0.3 * (double)colIndex;
                row[colIndex] = Double.valueOf(Math.cos(Math.hypot(x - 9.6, y - 9.6)) * Math.cos(Math.hypot(x + 9.6, y + 9.6)));
            }
            raster.add(row);
        }
        DataSource valuesByCoord = RasterPlot.createRasterData(raster);
        RasterPlot plot = new RasterPlot(valuesByCoord);
        plot.setInsets(new Insets2D.Double(20.0, 60.0, 40.0, 20.0));
        plot.setColors(new LinearGradient(GraphicsUtils.deriveDarker(COLOR1), COLOR1, Color.WHITE));
        InteractivePanel panel = new InteractivePanel(plot);
        panel.setPannable(false);
        panel.setZoomable(false);
        this.add(panel);
    }

    @Override
    public String getTitle() {
        return "Raster plot";
    }

    @Override
    public String getDescription() {
        return String.format("Raster plot of %d\u00d7%d values", 64, 64);
    }

    public static void main(String[] args) {
        new SimpleRasterPlot().showInFrame();
    }
}

