/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.examples.pieplot;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.DataTable;
import de.erichseifert.gral.examples.ExamplePanel;
import de.erichseifert.gral.graphics.Insets2D;
import de.erichseifert.gral.plots.PiePlot;
import de.erichseifert.gral.plots.colors.LinearGradient;
import de.erichseifert.gral.ui.InteractivePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Random;

public class SimplePiePlot
extends ExamplePanel {
    private static final long serialVersionUID = -3039317265508932299L;
    private static final int SAMPLE_COUNT = 10;
    private static final Random random = new Random();

    public SimplePiePlot() {
        DataTable data = new DataTable(Integer.class);
        for (int i = 0; i < 10; ++i) {
            int val = random.nextInt(8) + 2;
            data.add(Integer.valueOf(random.nextDouble() <= 0.15 ? -val : val));
        }
        DataSource pieData = PiePlot.createPieData(data);
        PiePlot plot = new PiePlot(pieData);
        plot.getTitle().setText(this.getDescription());
        plot.setRadius(0.9);
        plot.setLegendVisible(true);
        plot.setInsets(new Insets2D.Double(20.0, 40.0, 40.0, 40.0));
        PiePlot.PieSliceRenderer pointRenderer = (PiePlot.PieSliceRenderer)plot.getPointRenderer(pieData);
        pointRenderer.setInnerRadius(0.4);
        pointRenderer.setGap(0.2);
        LinearGradient colors = new LinearGradient(COLOR1, COLOR2);
        pointRenderer.setColor(colors);
        pointRenderer.setValueVisible(true);
        pointRenderer.setValueColor(Color.WHITE);
        pointRenderer.setValueFont(Font.decode(null).deriveFont(1));
        this.add((Component)new InteractivePanel(plot), "Center");
    }

    @Override
    public String getTitle() {
        return "Donut plot";
    }

    @Override
    public String getDescription() {
        return String.format("Donut plot of %d random data values", 10);
    }

    public static void main(String[] args) {
        new SimplePiePlot().showInFrame();
    }
}

