/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.statistics;

import de.erichseifert.gral.util.DataUtils;
import de.erichseifert.gral.util.MathUtils;
import de.erichseifert.gral.util.SortedList;
import java.util.HashMap;
import java.util.Map;

public class Statistics {
    public static final String N = "n";
    public static final String SUM = "sum";
    public static final String SUM2 = "sum2";
    public static final String SUM3 = "sum3";
    public static final String SUM4 = "sum4";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MEAN = "mean";
    public static final String SUM_OF_DIFF_SQUARES = "M2";
    public static final String SUM_OF_DIFF_CUBICS = "M3";
    public static final String SUM_OF_DIFF_QUADS = "M4";
    public static final String VARIANCE = "sample variance";
    public static final String POPULATION_VARIANCE = "population variance";
    public static final String SKEWNESS = "skewness";
    public static final String KURTOSIS = "kurtosis";
    public static final String MEDIAN = "quantile50";
    public static final String QUARTILE_1 = "quantile25";
    public static final String QUARTILE_2 = "quantile50";
    public static final String QUARTILE_3 = "quantile75";
    private final Iterable<? extends Comparable<?>> data;
    private final Map<String, Double> statistics = new HashMap<String, Double>();

    public Statistics(Iterable<? extends Comparable<?>> data) {
        this.data = data;
    }

    private void createBasicStats(Iterable<? extends Comparable<?>> data, Map<String, Double> stats) {
        double n = 0.0;
        double sum = 0.0;
        double sum2 = 0.0;
        double sum3 = 0.0;
        double sum4 = 0.0;
        double mean = 0.0;
        double sumOfDiffSquares = 0.0;
        double sumOfDiffCubics = 0.0;
        double sumOfDiffQuads = 0.0;
        for (Comparable<?> cell : data) {
            Number numericCell;
            if (!(cell instanceof Number) || !MathUtils.isCalculatable(numericCell = (Number)((Object)cell))) continue;
            double val = numericCell.doubleValue();
            if (!stats.containsKey(MIN) || val < stats.get(MIN)) {
                stats.put(MIN, val);
            }
            if (!stats.containsKey(MAX) || val > stats.get(MAX)) {
                stats.put(MAX, val);
            }
            n += 1.0;
            double val2 = val * val;
            sum += val;
            sum2 += val2;
            sum3 += val2 * val;
            sum4 += val2 * val2;
            double delta = val - mean;
            double deltaN = delta / n;
            double deltaN2 = deltaN * deltaN;
            double term1 = delta * deltaN * (n - 1.0);
            mean += deltaN;
            sumOfDiffQuads += term1 * deltaN2 * (n * n - 3.0 * n + 3.0) + 6.0 * deltaN2 * sumOfDiffSquares - 4.0 * deltaN * sumOfDiffCubics;
            sumOfDiffCubics += term1 * deltaN * (n - 2.0) - 3.0 * deltaN * sumOfDiffSquares;
            sumOfDiffSquares += term1;
        }
        stats.put(N, n);
        stats.put(SUM, sum);
        stats.put(SUM2, sum2);
        stats.put(SUM3, sum3);
        stats.put(SUM4, sum4);
        stats.put(MEAN, mean);
        stats.put(SUM_OF_DIFF_QUADS, sumOfDiffQuads);
        stats.put(SUM_OF_DIFF_CUBICS, sumOfDiffCubics);
        stats.put(SUM_OF_DIFF_SQUARES, sumOfDiffSquares);
        stats.put(VARIANCE, sumOfDiffSquares / (n - 1.0));
        stats.put(POPULATION_VARIANCE, sumOfDiffSquares / n);
        stats.put(SKEWNESS, sumOfDiffCubics / n / Math.pow(sumOfDiffSquares / n, 1.5) - 3.0);
        stats.put(KURTOSIS, n * sumOfDiffQuads / (sumOfDiffSquares * sumOfDiffSquares) - 3.0);
    }

    private void createDistributionStats(Iterable<? extends Comparable<?>> data, Map<String, Double> stats) {
        SortedList<Double> values = new SortedList<Double>();
        for (Comparable<?> cell : data) {
            Number numericCell;
            double value;
            if (!(cell instanceof Number) || !MathUtils.isCalculatable(value = (numericCell = (Number)((Object)cell)).doubleValue())) continue;
            values.add(value);
        }
        if (values.size() <= 0) {
            return;
        }
        stats.put(QUARTILE_1, MathUtils.quantile(values, 0.25));
        stats.put("quantile50", MathUtils.quantile(values, 0.5));
        stats.put(QUARTILE_3, MathUtils.quantile(values, 0.75));
        stats.put("quantile50", stats.get("quantile50"));
    }

    public double get(String key) {
        if (!this.statistics.containsKey(key)) {
            if ("quantile50".equals(key) || QUARTILE_1.equals(key) || "quantile50".equals(key) || QUARTILE_3.equals(key)) {
                this.createDistributionStats(this.data, this.statistics);
            } else {
                this.createBasicStats(this.data, this.statistics);
            }
        }
        Double v = this.statistics.get(key);
        return DataUtils.getValueOrDefault(v, Double.NaN);
    }
}

