/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data.filters;

import de.erichseifert.gral.data.filters.Filter;
import de.erichseifert.gral.data.filters.Kernel;
import de.erichseifert.gral.util.WindowIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ConvolutionFilter<T extends Number>
implements Filter<T> {
    private final List<Double> filtered = new LinkedList<Double>();
    private final Iterator<List<T>> windowIterator;

    public ConvolutionFilter(Iterable<T> data, Kernel kernel) {
        this.windowIterator = new WindowIterator<T>(data.iterator(), kernel.size());
        while (this.windowIterator.hasNext()) {
            List<T> window = this.windowIterator.next();
            double convolvedValue = 0.0;
            for (int windowIndex = 0; windowIndex < window.size(); ++windowIndex) {
                int kernelIndex = windowIndex - kernel.getOffset();
                convolvedValue += kernel.get(kernelIndex) * ((Number)window.get(windowIndex)).doubleValue();
            }
            this.filtered.add(convolvedValue);
        }
    }

    @Override
    public Iterator<Double> iterator() {
        return this.filtered.iterator();
    }
}

