/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.AbstractDataSource;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class JdbcData
extends AbstractDataSource {
    private static final long serialVersionUID = 5196527358266585129L;
    private final Connection connection;
    private final String table;
    private boolean buffered;
    private int bufferedRowCount;
    private ResultSet bufferedQuery;
    private int bufferedQueryRow;

    public JdbcData(Connection connection, String table, boolean buffered) {
        this.connection = connection;
        this.table = table;
        this.setBuffered(buffered);
        try {
            this.setColumnTypes(this.getJdbcColumnTypes());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public JdbcData(Connection connection, String table) {
        this(connection, table, true);
    }

    @Override
    public Comparable<?> get(int col, int row) {
        try {
            ResultSet result = this.bufferedQuery;
            if (!this.isBuffered() || result == null) {
                PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM " + this.table + "", 1005, 1007);
                result = stmt.executeQuery();
                if (this.isBuffered()) {
                    this.bufferedQuery = result;
                }
            }
            if (!this.isBuffered() || row != this.bufferedQueryRow) {
                result.absolute(row + 1);
                this.bufferedQueryRow = row;
            }
            return this.jdbcToJavaValue(result, col);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        if (this.getColumnTypes() != null) {
            return this.getColumnTypes().length;
        }
        return 0;
    }

    @Override
    public int getRowCount() {
        int rowCount = this.bufferedRowCount;
        if (!this.isBuffered() || rowCount < 0) {
            try {
                PreparedStatement stmt = this.connection.prepareStatement("SELECT COUNT(*) FROM " + this.table, 1005, 1007);
                ResultSet result = stmt.executeQuery();
                if (result.first()) {
                    this.bufferedRowCount = rowCount = result.getInt(1);
                } else {
                    rowCount = 0;
                }
                result.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
                rowCount = 0;
            }
        }
        return rowCount;
    }

    private Class<? extends Comparable<?>>[] getJdbcColumnTypes() throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("SELECT * FROM " + this.table + " WHERE 1 = 0");
        ResultSetMetaData metadata = stmt.getMetaData();
        int colCount = metadata.getColumnCount();
        Class[] types = new Class[colCount];
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            int sqlType = metadata.getColumnType(colIndex + 1);
            Class type = null;
            switch (sqlType) {
                case -6: {
                    type = Byte.class;
                    break;
                }
                case 5: {
                    type = Short.class;
                    break;
                }
                case 4: {
                    type = Integer.class;
                    break;
                }
                case -5: {
                    type = Long.class;
                    break;
                }
                case 7: {
                    type = Float.class;
                    break;
                }
                case 6: 
                case 8: {
                    type = Double.class;
                    break;
                }
                case 91: {
                    type = Date.class;
                    break;
                }
                case 92: {
                    type = Time.class;
                    break;
                }
                case 93: {
                    type = Timestamp.class;
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    type = String.class;
                }
            }
            types[colIndex] = type;
        }
        return types;
    }

    private Comparable<?> jdbcToJavaValue(ResultSet row, int col) throws SQLException {
        Class<? extends Comparable<?>> colType = this.getColumnTypes()[col];
        int sqlCol = col + 1;
        if (Byte.class.equals(colType)) {
            return row.getByte(sqlCol);
        }
        if (Short.class.equals(colType)) {
            return row.getShort(sqlCol);
        }
        if (Integer.class.equals(colType)) {
            return row.getInt(sqlCol);
        }
        if (Long.class.equals(colType)) {
            return row.getLong(sqlCol);
        }
        if (Float.class.equals(colType)) {
            return Float.valueOf(row.getFloat(sqlCol));
        }
        if (Double.class.equals(colType)) {
            return row.getDouble(sqlCol);
        }
        if (Date.class.equals(colType)) {
            return row.getDate(sqlCol);
        }
        if (Time.class.equals(colType)) {
            return row.getTime(sqlCol);
        }
        if (Timestamp.class.equals(colType)) {
            return row.getTimestamp(sqlCol);
        }
        if (String.class.equals(colType)) {
            return row.getString(sqlCol);
        }
        return null;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
        this.bufferedRowCount = -1;
        this.bufferedQuery = null;
        this.bufferedQueryRow = -1;
    }

    private void writeObject(ObjectOutputStream out) throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException("JDBC data sources cannot be serialized.");
    }
}

