/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.gral.data;

import de.erichseifert.gral.data.DataSource;
import de.erichseifert.gral.data.statistics.Statistics;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Locale;

public abstract class DataAccessor
implements Iterable<Comparable<?>>,
Serializable {
    private static final long serialVersionUID = -6977184455447753502L;
    private final DataSource source;
    private final int index;

    public DataAccessor(DataSource source, int index) {
        this.source = source;
        this.index = index;
    }

    public DataSource getSource() {
        return this.source;
    }

    public int getIndex() {
        return this.index;
    }

    public abstract Comparable<?> get(int var1);

    public abstract int size();

    public boolean equals(Object obj) {
        if (!(obj instanceof DataAccessor)) {
            return false;
        }
        DataAccessor accessor = (DataAccessor)obj;
        int size = this.size();
        if (accessor.size() != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            Comparable<?> foreignValue = accessor.get(i);
            Comparable<?> thisValue = this.get(i);
            if (!(foreignValue == null ? thisValue != null : !foreignValue.equals(thisValue))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.index;
    }

    public String toString() {
        return String.format(Locale.US, "%s[source=%s,index=%d]", this.getClass().getName(), this.getSource(), this.getIndex());
    }

    public Comparable<?>[] toArray(Comparable<?>[] data) {
        if (data == null) {
            data = new Comparable[this.size()];
        }
        if (data.length != this.size()) {
            throw new IllegalArgumentException(MessageFormat.format("Array of size {0,number,integer} does not match {1,number,integer} elements.", data.length, this.size()));
        }
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.get(i);
        }
        return data;
    }

    public double getStatistics(String key) {
        Statistics statistics = new Statistics(this);
        return statistics.get(key);
    }

    @Override
    public Iterator<Comparable<?>> iterator() {
        return new Iterator<Comparable<?>>(){
            private int i;

            @Override
            public boolean hasNext() {
                return this.i < DataAccessor.this.size();
            }

            @Override
            public Comparable<?> next() {
                Comparable<?> value = DataAccessor.this.get(this.i++);
                return value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

