/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.avlTree;

import java.awt.Color;
import jv.geom.PgPolygonSet;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.vecmath.PdVector;
import jvx.util.PuAVLTree;
import jvx.util.PuBinaryTreeNode;
import jvx.util.PuCompareStringsLexi;
import jvx.util.PuCompare_If;

public class PjAvlTree
extends PjProject {
    protected PgPolygonSet m_geom = new PgPolygonSet(2);
    protected PuAVLTree m_tree;
    static /* synthetic */ Class class$vgp$tutor$avlTree$PjAvlTree;

    public PjAvlTree() {
        super("AVL Tree Demo");
        this.m_geom.setName("Tree");
        this.m_tree = new PuAVLTree((PuCompare_If)new PuCompareStringsLexi());
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$avlTree$PjAvlTree == null ? (class$vgp$tutor$avlTree$PjAvlTree = PjAvlTree.class$("vgp.tutor.avlTree.PjAvlTree")) : class$vgp$tutor$avlTree$PjAvlTree)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_geom.showVertexLabels(true);
        this.m_geom.showVertexOutline(false);
        this.m_geom.setGlobalPolygonColor(new Color(191, 191, 191));
        this.m_geom.setGlobalVertexSize(0.0);
        this.m_geom.setLabelAttribute(0, 0, 0, 1, 1, 0);
    }

    public void start() {
        this.setEnabledAutoFit(true);
        if (this.m_display != null) {
            this.m_display.selectCamera(1);
            this.m_display.setBackgroundColor(Color.white);
        }
        this.computeGeom();
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
        super.start();
    }

    public void insert(String string) {
        this.m_tree.insert((Object)string);
        this.computeGeom();
        this.m_geom.update((Object)this.m_geom);
        if (this.isEnabledAutoFit()) {
            this.fitDisplays();
        }
    }

    public void remove(String string) {
        this.m_tree.remove((Object)string);
        this.computeGeom();
        this.m_geom.update((Object)this.m_geom);
        if (this.isEnabledAutoFit()) {
            this.fitDisplays();
        }
    }

    public void computeGeom() {
        int n = this.m_tree.getSize();
        if (n == 0) {
            return;
        }
        this.m_geom.setNumVertices(n);
        this.m_geom.setDimOfPolygons(2);
        this.m_geom.setNumPolygons(n - 1);
        double d = 1.0;
        double d2 = 1.0;
        PuBinaryTreeNode[] puBinaryTreeNodeArray = new PuBinaryTreeNode[n];
        int n2 = this.m_tree.getHeight();
        if (n2 < 1) {
            n2 = 1;
        }
        puBinaryTreeNodeArray[0] = this.m_tree.getRoot();
        this.m_geom.getVertex(0).setName((String)puBinaryTreeNodeArray[0].getValue());
        this.m_geom.getVertex(0).set(0.0, 0.0);
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            PuBinaryTreeNode puBinaryTreeNode;
            PdVector pdVector = this.m_geom.getVertex(i);
            PuBinaryTreeNode puBinaryTreeNode2 = puBinaryTreeNodeArray[i].getRight();
            if (puBinaryTreeNode2 != null) {
                puBinaryTreeNodeArray[n3] = puBinaryTreeNode2;
                this.m_geom.getVertex(n3).set(pdVector.m_data[0] + 1.0, pdVector.m_data[1] - Math.pow(0.5, pdVector.m_data[0] + 1.0));
                this.m_geom.getPolygon(n3 - 1).set(i, n3);
                this.m_geom.getVertex(n3).setName((String)puBinaryTreeNode2.getValue());
                ++n3;
            }
            if ((puBinaryTreeNode = puBinaryTreeNodeArray[i].getLeft()) != null) {
                puBinaryTreeNodeArray[n3] = puBinaryTreeNode;
                this.m_geom.getVertex(n3).set(pdVector.m_data[0] + 1.0, pdVector.m_data[1] + Math.pow(0.5, pdVector.m_data[0] + 1.0));
                this.m_geom.getPolygon(n3 - 1).set(i, n3);
                this.m_geom.getVertex(n3).setName((String)puBinaryTreeNode.getValue());
                ++n3;
            }
            pdVector.m_data[0] = pdVector.m_data[0] * (d / (1.0 * (double)n2));
            pdVector.m_data[1] = pdVector.m_data[1] * d2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

