/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Schoen_I_WP2
extends PgWeierstrassDescr {
    private PdVector m_p0 = new PdVector(0.5, Math.sqrt(0.5), -0.5);
    private PdVector m_p1 = new PdVector(Math.sqrt(0.5), 0.0, -Math.sqrt(0.5));
    private PdVector m_p2 = new PdVector(0.5, -Math.sqrt(0.5), 0.5);
    private PdVector m_p3 = new PdVector(Math.sqrt(0.5), 0.0, Math.sqrt(0.5));
    private double m_squeeze = 1.0;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Schoen_I_WP2;

    public PgWeierstrass_Schoen_I_WP2() {
        super(1);
        this.setName("Schoen I-WP");
        this.m_bMarkBnd = true;
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Schoen_I_WP2 == null ? (class$vgp$minimal$weier$PgWeierstrass_Schoen_I_WP2 = PgWeierstrass_Schoen_I_WP2.class$("vgp.minimal.weier.PgWeierstrass_Schoen_I_WP2")) : class$vgp$minimal$weier$PgWeierstrass_Schoen_I_WP2)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_conjugation.setDefBounds(0.0, Math.PI * 2, 0.06544984694978735, 0.5235987755982988);
        this.m_conjugation.setDefValue(0.0);
        this.m_conjugation.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 5);
        this.m_numLines[0].setDefValue(15);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 5);
        this.m_numLines[1].setDefValue(7);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.setNumIntegratedPatches(2);
        this.setDomain(0, 0.0, 1.0, 0.0, 0.5);
        this.setDomain(1, 0.0, 1.0, 0.5, 1.0);
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        double d = puComplex.re + this.m_squeeze * (puComplex.re - 1.0) * puComplex.re * (puComplex.im - puComplex.re) * (puComplex.im - puComplex.re) * (puComplex.im - puComplex.re);
        double d2 = puComplex.im + this.m_squeeze * (puComplex.im - 1.0) * puComplex.im * (puComplex.re - puComplex.im) * (puComplex.re - puComplex.im) * (puComplex.re - puComplex.im);
        PdVector pdVector = PdVector.blendNew((double)(d * d2), (PdVector)this.m_p0, (double)(d * (1.0 - d2)), (PdVector)this.m_p1);
        pdVector.blendBase(pdVector, (1.0 - d) * (1.0 - d2), this.m_p2);
        pdVector.blendBase(pdVector, (1.0 - d) * d2, this.m_p3);
        pdVector.normalize();
        pdVector.multScalar(1.0 / (1.0 + pdVector.m_data[2]));
        PuComplex puComplex2 = new PuComplex(pdVector.m_data[0], pdVector.m_data[1]);
        puComplex2.sqr();
        if (n == 0) {
            puComplex2.sub(3.0 + 2.0 * Math.sqrt(2.0));
        } else {
            puComplex2.sub(3.0 - 2.0 * Math.sqrt(2.0));
            puComplex2.mult(PuComplex.NEG_ONE);
        }
        puComplex2.pow(0.3333333333333333);
        if (n == 1) {
            puComplex2.div(PuComplex.pow((PuComplex)PuComplex.NEG_ONE, (double)0.3333333333333333));
        }
        if (n == 1) {
            puComplex2.sub(2.0);
        }
        return puComplex2;
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2;
        boolean bl = puComplex.re > 0.0;
        PuComplex puComplex3 = new PuComplex(puComplex);
        if (!bl) {
            puComplex3.add(2.0);
        }
        PuComplex puComplex4 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)puComplex3);
        puComplex4.mult(puComplex3);
        PuComplex puComplex5 = bl ? PuComplex.add((PuComplex)puComplex4, (double)(4.0 + 2.0 * Math.sqrt(2.0))) : PuComplex.add((PuComplex)puComplex4, (double)(4.0 - 2.0 * Math.sqrt(2.0)));
        puComplex5.mult(PuComplex.NEG_I);
        puComplex5.pow(0.3333333333333333);
        puComplex5.mult(PuComplex.NEG_I);
        if (bl) {
            puComplex2 = PuComplex.add((PuComplex)puComplex4, (double)(4.0 * Math.sqrt(2.0)));
            puComplex2.mult(PuComplex.NEG_ONE);
        } else {
            puComplex2 = PuComplex.sub((PuComplex)puComplex4, (double)(4.0 * Math.sqrt(2.0)));
        }
        puComplex2.pow(0.3333333333333333);
        if (!bl) {
            puComplex2.mult(PuComplex.pow((PuComplex)PuComplex.NEG_ONE, (double)0.3333333333333333));
        }
        PuComplex puComplex6 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)puComplex2);
        puComplex6 = PuComplex.mult((PuComplex)puComplex6, (PuComplex)puComplex6);
        PuComplex puComplex7 = bl ? PuComplex.add((PuComplex)puComplex4, (double)(3.0 + 2.0 * Math.sqrt(2.0))) : PuComplex.add((PuComplex)puComplex4, (double)(3.0 - 2.0 * Math.sqrt(2.0)));
        puComplex7.mult(PuComplex.NEG_ONE);
        puComplex7.sqrt();
        puComplex7.mult(PuComplex.NEG_I);
        puComplex7.mult(0.6666666666666666);
        puComplex6.mult(puComplex7);
        return puComplex6.inv();
    }

    public PuComplex g(PuComplex puComplex) {
        boolean bl = puComplex.re > 0.0;
        PuComplex puComplex2 = new PuComplex(puComplex);
        if (!bl) {
            puComplex2.add(2.0);
        }
        PuComplex puComplex3 = PuComplex.mult((PuComplex)puComplex2, (PuComplex)puComplex2);
        puComplex3.mult(puComplex2);
        if (bl) {
            puComplex3.add(3.0 + 2.0 * Math.sqrt(2.0));
        } else {
            puComplex3.add(3.0 - 2.0 * Math.sqrt(2.0));
        }
        puComplex3.mult(PuComplex.NEG_ONE);
        puComplex3.sqrt();
        puComplex3.mult(PuComplex.NEG_I);
        return puComplex3;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(2, 3, 0, 3);
            this.connectPart(3, 3, 1, 3);
            this.connectPart(6, 3, 4, 3);
            this.connectPart(7, 3, 5, 3);
            this.connectPart(7, 0, 6, 0);
        }
        if (this.equals(piVector, new int[]{0, 0})) {
            this.connectPart(1, 0, 0, 2);
        }
    }

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 0);
            this.reflectPart(2, 0, 1);
            this.reflectPart(3, 1, 1);
            this.reflectPart(4, 2, 0);
            this.reflectPart(5, 3, 0);
            this.reflectPart(6, 4, 1);
            this.reflectPart(7, 5, 1);
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        piVector2.m_data[0] = 0;
        piVector2.m_data[1] = 0;
        piVector2.m_data[2] = 0;
        piVector2.m_data[3] = 0;
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return piVector != null;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0 || this.equals(piVector, 0) && n == 0;
    }

    public int getNumParts(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            return 8;
        }
        if (this.equals(piVector, new int[]{0, 0})) {
            return 2;
        }
        return this.m_numUserReflections + 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

