/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_CatKExp
extends PgWeierstrassDescr {
    private final double m_defaultRadius = 2.0;
    private final int m_defaultSymmetry = 2;
    protected PuDouble m_dRadius;
    protected PuInteger m_iSymmetry;
    private double m_radius = 2.0;
    private int m_symmetry = 2;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_CatKExp;

    public PgWeierstrass_CatKExp() {
        super(1);
        this.setName("Catenoid with k-Exp");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_iSymmetry = new PuInteger("Exponent", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_CatKExp == null ? (class$vgp$minimal$weier$PgWeierstrass_CatKExp = PgWeierstrass_CatKExp.class$("vgp.minimal.weier.PgWeierstrass_CatKExp")) : class$vgp$minimal$weier$PgWeierstrass_CatKExp)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(31);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(7, 300, 1, 10);
        this.m_numLines[1].setDefValue(21);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadius.setDefBounds(0.5, 5.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(2.0);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_iSymmetry.setDefBounds(2, 20, 1, 5);
        this.m_iSymmetry.setDefValue(2);
        this.m_iSymmetry.init();
        this.addParameter((PsObject)this.m_iSymmetry);
        this.setDomain(0, -2.0, 2.0, 0.0, Math.PI * 2);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMin(0, -this.m_radius);
            this.setUMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_iSymmetry) {
            this.m_symmetry = this.m_iSymmetry.getValue();
            this.setVMax(0, Math.PI * 2 / (double)(this.m_symmetry - 1));
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        return PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.pow((PuComplex)puComplex, (int)this.m_symmetry);
        return puComplex2.inv();
    }

    public PuComplex g(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.pow((PuComplex)puComplex, (int)(this.m_symmetry - 1));
        return puComplex2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

