/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_CatEnn2Ends
extends PgWeierstrassDescr {
    private final double m_defaultRadiusTop = 0.8;
    private final double m_defaultRadiusBottom = 1.3;
    private final double m_defaultNeckSize = 3.0;
    protected PuDouble m_dRadiusTop;
    protected PuDouble m_dRadiusBottom;
    protected PuDouble m_dNeckSize;
    private double m_radiusTop = 0.8;
    private double m_radiusBottom = 1.3;
    private double m_neckSize = 3.0;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_CatEnn2Ends;

    public PgWeierstrass_CatEnn2Ends() {
        super(1);
        this.setName("Catenoid - Enneper with 2 Ends");
        this.m_dRadiusTop = new PuDouble("Radius Top", (PsUpdateIf)this);
        this.m_dRadiusBottom = new PuDouble("Radius Bottom", (PsUpdateIf)this);
        this.m_dNeckSize = new PuDouble("Necksize", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_CatEnn2Ends == null ? (class$vgp$minimal$weier$PgWeierstrass_CatEnn2Ends = PgWeierstrass_CatEnn2Ends.class$("vgp.minimal.weier.PgWeierstrass_CatEnn2Ends")) : class$vgp$minimal$weier$PgWeierstrass_CatEnn2Ends)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(33);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(7, 300, 1, 10);
        this.m_numLines[1].setDefValue(17);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadiusTop.setDefBounds(0.1, 5.0, 0.1, 1.0);
        this.m_dRadiusTop.setDefValue(0.8);
        this.m_dRadiusTop.init();
        this.addParameter((PsObject)this.m_dRadiusTop);
        this.m_dRadiusBottom.setDefBounds(0.1, 5.0, 0.1, 1.0);
        this.m_dRadiusBottom.setDefValue(1.3);
        this.m_dRadiusBottom.init();
        this.addParameter((PsObject)this.m_dRadiusBottom);
        this.m_dNeckSize.setDefBounds(1.0, 10.0, 0.1, 1.0);
        this.m_dNeckSize.setDefValue(3.0);
        this.m_dNeckSize.init();
        this.addParameter((PsObject)this.m_dNeckSize);
        this.setDomain(0, -0.8, 1.3, 0.0, 1.5707963267948966);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadiusBottom) {
            this.m_radiusBottom = this.m_dRadiusBottom.getValue();
            this.setUMax(0, this.m_radiusBottom);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadiusTop) {
            this.m_radiusTop = this.m_dRadiusTop.getValue();
            this.setUMin(0, -this.m_radiusTop);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dNeckSize) {
            this.m_neckSize = this.m_dNeckSize.getValue();
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        double d = puComplex.re * Math.log(this.twoenncatb(this.m_neckSize));
        return PuComplex.polarToRect((double)Math.exp(d), (double)puComplex.im);
    }

    public PuComplex f(PuComplex puComplex) {
        double d = this.m_neckSize * this.m_neckSize;
        PuComplex puComplex2 = PuComplex.sqr((PuComplex)puComplex);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)puComplex2, (double)d), (double)1.0);
        puComplex3 = PuComplex.div((PuComplex)puComplex3, (PuComplex)puComplex2);
        puComplex3 = PuComplex.sqr((PuComplex)puComplex3);
        PuComplex puComplex4 = PuComplex.div((PuComplex)puComplex3, (double)Math.pow(this.m_neckSize, 5.5));
        return puComplex4;
    }

    public PuComplex g(PuComplex puComplex) {
        double d = this.m_neckSize * this.m_neckSize;
        PuComplex puComplex2 = PuComplex.sqr((PuComplex)puComplex);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex2, (double)d);
        PuComplex puComplex4 = PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)puComplex2, (double)d), (double)1.0);
        PuComplex puComplex5 = PuComplex.div((PuComplex)puComplex3, (PuComplex)puComplex4);
        return puComplex5.mult(puComplex);
    }

    private double twoenncatb(double d) {
        double d2 = -2.0;
        double d3 = 4.0;
        double d4 = 0.0;
        double d5 = -1.0;
        if (d != d5) {
            d5 = d;
            double d6 = d * d;
            double d7 = 27.0 * d3 - d6 * d6 * (18.0 * d3 + d6 * (4.0 * (1.0 + d3 * d3) + d6 * d3));
            d7 = Math.sqrt(Math.abs(d7));
            d4 = d2 * (-27.0 + d6 * d6 * (9.0 + 2.0 * d3 * d6));
            d4 = Math.sqrt(27.0) * d7 + d4;
            d4 = Math.pow(Math.abs(d4), 0.3333333333333333);
            d4 = d6 * (d2 + Math.pow(2.0, 0.3333333333333333) * (3.0 + d3 * d6) / d4) + d4 / Math.pow(2.0, 0.3333333333333333);
            d4 /= 3.0;
        }
        return d4;
    }

    public void getReflections() {
        this.reflectPart(1, 0, 0);
        this.reflectPart(2, 0, 2);
        this.reflectPart(3, 1, 2);
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (piVector == null && n == 0) {
            piVector2.m_data[0] = 0;
            piVector2.m_data[2] = 0;
        }
    }

    public int getNumParts() {
        return 4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

