/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.curvature;

import java.awt.Color;
import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickEvent;
import jv.vecmath.PdVector;
import jv.viewer.PvDisplay;
import jvx.geom.PwRefinePolygon;
import jvx.project.PjWorkshop_Dialog;

public class PjCurvature
extends PjProject {
    protected PgPolygon m_poly;
    protected PvDisplay m_sphereDisp;
    protected boolean m_bPicking = true;
    protected PgPointSet m_position;
    protected PuDouble m_positionOnCurve;
    protected PgPolygon m_circle;
    protected PgPointSet m_midPoint;
    protected PgVectorField m_circleVector;
    protected PgVectorField m_vectorOnCurve;
    protected PgPointSet m_historyPoints;
    protected PgVectorField m_historyField;
    protected PgPolygon m_angleArc;
    protected double m_angleBegin;
    protected PjWorkshop_Dialog m_refineDialog = null;
    protected PwRefinePolygon m_refineWS = null;
    protected boolean m_bShowTrace = true;
    protected static final double MAX_ANIM = 200.0;
    static /* synthetic */ Class class$vgp$discrete$curvature$PjCurvature;

    public PjCurvature() {
        super("Curvature and Normals");
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.setName("Moving Normal");
        psAnimation.addTimeListener((PsTimeListenerIf)this);
        psAnimation.setTimeInterval(0.0, 200.0, 1.0, 10.0);
        this.m_sphereDisp = new PvDisplay();
        this.m_sphereDisp.setBackgroundColor(Color.white);
        this.m_sphereDisp.selectCamera(1);
        this.m_sphereDisp.showScenegraph(false);
        this.m_sphereDisp.showCopyright(false);
        this.m_circle = new PgPolygon(2);
        this.m_circle.setName(PsConfig.getMessage((int)75000));
        this.m_circle.computeCircle(100, 1.0);
        this.m_circle.showVertices(false);
        this.m_sphereDisp.addGeometry((PgGeometryIf)this.m_circle);
        this.m_historyField = new PgVectorField(2);
        this.m_historyField.setName(PsConfig.getMessage((int)75001));
        this.m_historyPoints = new PgPointSet(2);
        this.m_historyPoints.setName(PsConfig.getMessage((int)75002));
        this.m_historyPoints.setNumVertices(0);
        this.m_historyField.setGeometry(this.m_historyPoints);
        this.m_historyPoints.addVectorField(this.m_historyField);
        this.m_historyPoints.setGlobalVectorColor(Color.gray);
        this.m_historyPoints.showVectorArrows(true);
        this.m_sphereDisp.addGeometry((PgGeometryIf)this.m_historyPoints);
        this.m_midPoint = new PgPointSet(2);
        this.m_midPoint.setName(PsConfig.getMessage((int)75003));
        this.m_midPoint.addVertex(new PdVector(0.0, 0.0));
        this.m_midPoint.showVertices(true);
        this.m_midPoint.showVertexLabels(true);
        this.m_midPoint.getVertex(0).setName("");
        this.m_circleVector = new PgVectorField(2);
        this.m_circleVector.setName(PsConfig.getMessage((int)75004));
        this.m_circleVector.setGeometry(this.m_midPoint);
        this.m_midPoint.addVectorField(this.m_circleVector);
        this.m_midPoint.showVectorArrows(true);
        this.m_midPoint.setGlobalVectorColor(Color.red);
        this.m_midPoint.setGlobalVectorSize(3.0);
        this.m_midPoint.update((Object)this.m_midPoint);
        this.m_sphereDisp.addGeometry((PgGeometryIf)this.m_midPoint);
        this.m_positionOnCurve = new PuDouble(PsConfig.getMessage((int)88000), (PsUpdateIf)this);
        this.m_positionOnCurve.setDefBounds(0.0, 1.0, 1.0, 1.0);
        this.m_positionOnCurve.setDefValue(0.0);
        this.m_positionOnCurve.init();
        this.m_position = new PgPointSet(2);
        this.m_position.setName(PsConfig.getMessage((int)75006));
        this.m_position.setNumVertices(1);
        this.m_vectorOnCurve = new PgVectorField(2);
        this.m_vectorOnCurve.setName(PsConfig.getMessage((int)75007));
        this.m_vectorOnCurve.setGeometry(this.m_position);
        this.m_position.addVectorField(this.m_vectorOnCurve);
        this.m_position.showVectorArrows(true);
        this.m_position.setGlobalVectorColor(Color.blue);
        this.m_position.setGlobalVectorSize(3.0);
        this.m_position.update((Object)this.m_position);
        this.m_angleArc = new PgPolygon(2);
        this.m_angleArc.setName(PsConfig.getMessage((int)75008));
        this.m_angleArc.showVertices(false);
        this.m_angleArc.showEdges(true);
        this.m_angleArc.setGlobalEdgeSize(3.0);
        this.m_angleArc.setGlobalEdgeColor(Color.red);
        this.m_sphereDisp.addGeometry((PgGeometryIf)this.m_angleArc);
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$curvature$PjCurvature == null ? (class$vgp$discrete$curvature$PjCurvature = PjCurvature.class$("vgp.discrete.curvature.PjCurvature")) : class$vgp$discrete$curvature$PjCurvature)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        if (this.getAnimation() != null) {
            this.getAnimation().stop();
        }
        if (this.getDisplay() != null && this.m_poly != null) {
            this.getDisplay().removeGeometry((PgGeometryIf)this.m_poly);
            this.getDisplay().update((Object)this.getDisplay());
            this.m_poly.removeUpdateListener((PsUpdateIf)this);
        }
        if (this.m_refineWS != null) {
            this.m_refineWS.cancel();
        }
        if (this.m_refineDialog != null) {
            this.m_refineDialog.dispose();
        }
        this.m_refineWS = null;
        this.m_refineDialog = null;
        this.m_poly = new PgPolygon(2);
        this.m_poly.setName(PsConfig.getMessage((int)75009) + "[" + PsObject.getNumObjects() + "]");
        this.m_poly.addUpdateListener((PsUpdateIf)this);
        this.m_bPicking = true;
        this.m_position.showVertices(false);
        this.m_position.showVectorFields(false);
        this.m_positionOnCurve.setEnabled(false);
        this.m_angleArc.setNumVertices(0);
        this.m_angleArc.update(null);
        this.m_midPoint.showVertices(false);
        this.m_midPoint.showVectorFields(false);
        this.m_midPoint.update(null);
        this.m_historyPoints.setNumVertices(0);
        this.m_historyPoints.update((Object)this.m_historyPoints);
        if (this.getDisplay() != null) {
            this.getDisplay().addGeometry((PgGeometryIf)this.m_poly);
            this.getDisplay().selectGeometry((PgGeometryIf)this.m_poly);
        }
        this.m_poly.update(null);
        this.m_position.update(null);
    }

    protected void animate() {
        if (this.getAnimation() != null) {
            this.getAnimation().setTime(this.m_positionOnCurve.getValue() / this.m_positionOnCurve.getMax() * 200.0);
            this.getAnimation().getAnimationPanel().setVisible(true);
            this.getAnimation().start();
        }
    }

    protected void openRefineCoarsen() {
        if (this.m_bPicking) {
            return;
        }
        if (this.m_refineWS == null) {
            this.m_refineWS = new PwRefinePolygon();
            this.m_refineDialog = new PjWorkshop_Dialog(false);
        }
        this.m_refineWS.setDisplay(this.getDisplay());
        this.m_refineWS.setGeometry(this.m_poly);
        this.m_refineDialog.setParent((PsUpdateIf)this.m_refineWS);
        this.m_refineDialog.update((Object)this.m_refineWS);
        this.m_refineDialog.setVisible(true);
    }

    protected void setShowTrace(boolean bl) {
        this.m_bShowTrace = bl;
        if (!this.m_bPicking) {
            this.computeVectors();
        }
        this.update((Object)this);
    }

    public PvDisplayIf getSphereDisplay() {
        return this.m_sphereDisp;
    }

    public void start() {
        if (this.getDisplay() != null) {
            this.getDisplay().selectCamera(1);
            this.getDisplay().addGeometry((PgGeometryIf)this.m_poly);
            this.getDisplay().addGeometry((PgGeometryIf)this.m_position);
            this.getDisplay().setBackgroundColor(Color.white);
            this.getDisplay().setMajorMode(13);
            this.m_poly.update(null);
            this.m_position.update(null);
        }
        this.getViewer().addDisplay("UnitSphere", (PvDisplayIf)this.m_sphereDisp);
        super.start();
    }

    public void stop() {
        if (this.m_refineWS != null) {
            this.m_refineDialog.dispose();
            this.m_refineWS.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setTime(PsTimeEvent psTimeEvent) {
        if (this.m_bPicking) {
            return true;
        }
        double d = psTimeEvent.getTime();
        d /= 200.0;
        PgPolygon pgPolygon = this.m_poly;
        synchronized (pgPolygon) {
        }
        this.m_positionOnCurve.setValue(d *= this.m_poly.getLength());
        this.m_positionOnCurve.update((Object)this.m_positionOnCurve);
        return true;
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        if (!this.m_bPicking) {
            this.init();
            this.update((Object)this);
        }
        PdVector pdVector = pvPickEvent.getVertex();
        PdVector pdVector2 = new PdVector(pdVector.m_data[0], pdVector.m_data[1]);
        if (this.m_poly.getNumVertices() == 0 || PdVector.dist((PdVector)pdVector2, (PdVector)this.m_poly.getVertex(this.m_poly.getNumVertices() - 1)) > 1.0E-10) {
            this.m_poly.addVertex(pdVector2);
            this.m_poly.update((Object)this.m_poly);
        }
    }

    public void endPicking() {
        if (!this.m_bPicking) {
            return;
        }
        if (this.m_poly.getNumVertices() < 3 && this.m_poly.isClosed()) {
            return;
        }
        if (this.m_poly.getNumVertices() < 2) {
            return;
        }
        this.m_bPicking = false;
        this.m_poly.showVertices(false);
        this.m_poly.update((Object)this.m_poly);
        this.m_positionOnCurve.setValue(0.0);
        this.m_positionOnCurve.setEnabled(true);
        this.m_position.showVertices(true);
        this.m_position.showVectorFields(true);
        this.m_position.update(null);
        this.computeStartingVectorAndLengthBounds();
        this.update((Object)this);
    }

    private void computeStartingVectorAndLengthBounds() {
        double d = this.m_positionOnCurve.getValue() / this.m_positionOnCurve.getMax();
        double d2 = this.m_poly.getLength();
        this.m_positionOnCurve.setDefBounds(0.0, d2, d2 / 100.0, d2 / 10.0);
        this.m_positionOnCurve.setValue(d * d2);
        this.m_positionOnCurve.setDefValue(this.m_positionOnCurve.getValue());
        this.m_positionOnCurve.init();
        this.m_positionOnCurve.update((Object)this.m_positionOnCurve);
        PdVector pdVector = new PdVector(2);
        this.computeNormalOfPolygon(0, pdVector, this.m_poly.getNumVertices());
        this.m_angleBegin = Math.acos(pdVector.m_data[0]);
        if (pdVector.m_data[1] < 0.0) {
            this.m_angleBegin = -this.m_angleBegin;
        }
        this.m_midPoint.showVertices(true);
        this.m_midPoint.showVectorFields(true);
        this.m_midPoint.update(null);
    }

    public boolean update(Object object) {
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_positionOnCurve) {
            this.computeVectors();
            return super.update(null);
        }
        if (object == this.m_poly) {
            if (!this.m_bPicking) {
                this.computeStartingVectorAndLengthBounds();
                this.computeVectors();
            }
            return super.update(null);
        }
        return super.update(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeVectors() {
        PgPolygon pgPolygon = this.m_poly;
        synchronized (pgPolygon) {
            int n;
            int n2 = n = this.m_poly.getNumVertices();
            double d = this.m_positionOnCurve.getValue();
            double d2 = 0.0;
            double d3 = 0.0;
            int n3 = -1;
            double d4 = 0.0;
            PdVector pdVector = new PdVector(2);
            PdVector pdVector2 = new PdVector(2);
            PdVector pdVector3 = new PdVector(3);
            PdVector pdVector4 = new PdVector(3);
            PdVector pdVector5 = new PdVector(0.0, 0.0, 1.0);
            n3 = 0;
            d4 = 0.0;
            pdVector.sub(this.m_poly.getVertex((n3 + 1) % n), this.m_poly.getVertex(n3));
            pdVector3.set(pdVector.m_data[0], pdVector.m_data[1], 0.0);
            d2 = d3 = pdVector.length();
            this.m_historyPoints.setNumVertices(0);
            int n4 = 0;
            d2 = this.m_poly.isClosed() ? (d2 -= 1.0E-9) : (d2 += 1.0E-9);
            while (d2 < d) {
                if (++n4 > 1 && this.m_bShowTrace || n4 <= 1) {
                    this.m_historyPoints.setNumVertices(n4);
                    this.m_historyField.setNumVectors(n4);
                    this.m_historyField.setVector(n4 - 1, new PdVector(Math.cos(d4 + this.m_angleBegin), Math.sin(d4 + this.m_angleBegin)));
                }
                if (++n3 >= n2) {
                    n3 %= n2;
                }
                pdVector2.sub(this.m_poly.getVertex((n3 + 1) % n), this.m_poly.getVertex(n3));
                pdVector4.set(pdVector2.m_data[0], pdVector2.m_data[1], 0.0);
                d4 += PdVector.angleWithOrientation((PdVector)pdVector3, (PdVector)pdVector4, (PdVector)pdVector5);
                pdVector.copy(pdVector2);
                pdVector3.copy(pdVector4);
                d3 = pdVector.length();
                d2 += d3;
            }
            this.m_historyPoints.update((Object)this.m_historyPoints);
            PdVector pdVector6 = new PdVector(2);
            this.computeNormalOfPolygon(n3, pdVector6, n2);
            this.m_circleVector.setVector(0, pdVector6);
            this.m_circleVector.update((Object)this.m_circleVector);
            pdVector6.multScalar(2.0);
            this.m_vectorOnCurve.setVector(0, pdVector6);
            this.m_vectorOnCurve.update((Object)this.m_vectorOnCurve);
            d4 = d4 / Math.PI * 180.0;
            int n5 = (int)(d4 + 0.5);
            this.m_midPoint.getVertex(0).setName(" " + n5 + " degree");
            this.m_midPoint.update(null);
            double d5 = (d - (d2 - d3)) / d3;
            pdVector6.copy(pdVector);
            pdVector6.multScalar(d5);
            pdVector6.add(this.m_poly.getVertex(n3));
            this.m_position.setVertex(0, pdVector6);
            this.m_position.update(null);
            int n6 = (int)Math.abs(d4 / 2.0) + 1;
            double d6 = Math.PI / 90;
            if (d4 < 0.0) {
                d6 = -d6;
            }
            double d7 = this.m_angleBegin;
            this.m_angleArc.setNumVertices(n6);
            for (int i = 0; i < n6 - 1; ++i) {
                double d8 = Math.exp(-Math.abs(d7 - this.m_angleBegin) / 5.0 / Math.PI) * 0.3 + 0.05;
                this.m_angleArc.setVertex(i, Math.cos(d7) * d8, Math.sin(d7) * d8);
                d7 += d6;
            }
            d7 = d4 / 180.0 * Math.PI + this.m_angleBegin;
            double d9 = Math.exp(-Math.abs(d7 - this.m_angleBegin) / 5.0 / Math.PI) * 0.3 + 0.05;
            this.m_angleArc.setVertex(n6 - 1, Math.cos(d7) * d9, Math.sin(d7) * d9);
            this.m_angleArc.update((Object)this.m_angleArc);
        }
    }

    private void computeNormalOfPolygon(int n, PdVector pdVector, int n2) {
        pdVector.copy(this.m_poly.getVertex((n + 1) % n2));
        pdVector.sub(this.m_poly.getVertex(n));
        pdVector.set(pdVector.m_data[1], -pdVector.m_data[0]);
        pdVector.normalize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

