/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.python.core.AbstractArray;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyArray$PyExposer;
import org.python.core.PyArrayDerived;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleBuffer;
import org.python.core.buffer.SimpleStringBuffer;
import org.python.core.util.ByteSwapper;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.gc;

@ExposedType(name="array.array", base=PyObject.class)
public class PyArray
extends PySequence
implements Cloneable,
BufferProtocol,
Traverseproc {
    public static final PyType TYPE;
    private Object data;
    private Class<?> itemClass;
    private ItemType itemType;
    private ArrayDelegate delegate;
    private static final String NOT_ENOUGH_IN_FILE = "not enough items in file. %d requested, %d actually read";
    private WeakReference<BaseBuffer> export;

    public PyArray(PyType subtype) {
        super(subtype);
    }

    PyArray(PyType subtype, ItemType itemType, Class<?> itemClass, Object data) {
        this(subtype);
        this.setElementType(itemType, itemClass);
        this.setData(data);
    }

    PyArray(PyType subtype, ItemType itemType, Class<?> itemClass, int n) {
        this(subtype);
        this.setElementType(itemType, itemClass);
        this.setData(Array.newInstance(this.itemClass, n));
    }

    PyArray(PyType subtype, ItemType itemType, Class<?> itemClass, PyObject initial) {
        this(subtype, itemType, itemClass, 0);
        this.useInitial(initial);
    }

    public PyArray(Class<?> itemClass, Object data) {
        this(TYPE, ItemType.OBJECT, itemClass, data);
    }

    public PyArray(Class<?> itemClass, PyObject initial) {
        this(TYPE, ItemType.OBJECT, itemClass, initial);
    }

    public PyArray(Class<?> itemClass, int n) {
        this(TYPE, ItemType.OBJECT, itemClass, Array.newInstance(itemClass, n));
    }

    public PyArray(PyArray toCopy) {
        this(TYPE, toCopy.itemType, toCopy.itemClass, toCopy.delegate.copyArray());
    }

    private void setElementType(ItemType itemType, Class<?> itemClass) {
        if (itemType == ItemType.OBJECT) {
            this.itemClass = itemClass;
            this.itemType = ItemType.fromJavaClass(itemClass);
        } else {
            this.itemType = itemType;
            this.itemClass = itemType.itemClass;
        }
    }

    private void setData(Object data) {
        this.data = data != null ? data : Array.newInstance(this.itemClass, 0);
        this.delegate = new ArrayDelegate();
    }

    private void useInitial(PyObject initial) {
        if (this.data == null || this.delegate == null) {
            this.setData(Array.newInstance(this.itemClass, 0));
        }
        if (initial != null) {
            if (initial instanceof PyList) {
                this.fromlist(initial);
            } else if (initial instanceof PyString && !(initial instanceof PyUnicode)) {
                this.fromstring(initial.toString());
            } else if (this.itemType == ItemType.UNICHAR) {
                if (initial instanceof PyUnicode) {
                    this.extendArray((PyUnicode)initial);
                } else {
                    this.extendUnicodeIter(initial);
                }
            } else {
                this.extendInternal(initial);
            }
        }
    }

    @ExposedNew
    static final PyObject array_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (new_.for_type != subtype && keywords.length > 0) {
            int argc = args.length - keywords.length;
            PyObject[] justArgs = new PyObject[argc];
            System.arraycopy(args, 0, justArgs, 0, argc);
            args = justArgs;
        }
        PyArray self = new_.for_type == subtype ? new PyArray(subtype) : new PyArrayDerived(subtype);
        ArgParser ap = new ArgParser("array", args, Py.NoKeywords, new String[]{"typecode", "initializer"}, 1);
        ap.noKeywords();
        PyObject obj = ap.getPyObject(0);
        if (obj instanceof PyString && !(obj instanceof PyUnicode)) {
            if (obj.__len__() != 1) {
                throw Py.TypeError("array() argument 1 must be char, not str");
            }
            char typecode = obj.toString().charAt(0);
            self.setElementType(ItemType.fromTypecode(typecode), null);
        } else if (obj instanceof PyJavaType) {
            Class<?> itemClass = ((PyJavaType)obj).getProxyType();
            self.setElementType(ItemType.OBJECT, itemClass);
        } else {
            throw Py.TypeError("array() argument 1 must be char, not " + obj.getType().fastGetName());
        }
        self.useInitial(ap.getPyObject(1, null));
        return self;
    }

    public static PyArray zeros(int n, char typecode) {
        return new PyArray(TYPE, ItemType.fromTypecode(typecode), null, n);
    }

    public static PyArray zeros(int n, Class<?> itemClass) {
        return new PyArray(TYPE, ItemType.OBJECT, itemClass, n);
    }

    public static PyArray array(PyObject seq, char typecode) {
        return new PyArray(TYPE, ItemType.fromTypecode(typecode), null, seq);
    }

    public static Class<?> array_class(Class<?> type) {
        return Array.newInstance(type, 0).getClass();
    }

    public static PyArray array(PyObject init, Class<?> itemClass) {
        return new PyArray(TYPE, ItemType.OBJECT, itemClass, init);
    }

    final PyObject array___ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final PyObject array___eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    @Override
    public int hashCode() {
        return this.array___hash__();
    }

    final int array___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    final PyObject array___lt__(PyObject o) {
        return this.seq___lt__(o);
    }

    final PyObject array___le__(PyObject o) {
        return this.seq___le__(o);
    }

    final PyObject array___gt__(PyObject o) {
        return this.seq___gt__(o);
    }

    final PyObject array___ge__(PyObject o) {
        return this.seq___ge__(o);
    }

    final boolean array___contains__(PyObject o) {
        return this.object___contains__(o);
    }

    final void array___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void array___setitem__(PyObject o, PyObject def) {
        this.seq___setitem__(o, def);
    }

    final PyObject array___getitem__(PyObject o) {
        PyObject ret = this.seq___finditem__(o);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o);
        }
        return ret;
    }

    final boolean array___nonzero__() {
        return this.seq___nonzero__();
    }

    public PyObject array___iter__() {
        return this.seq___iter__();
    }

    final PyObject array___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final void array___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final void array___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    public PyObject __imul__(PyObject o) {
        return this.array___imul__(o);
    }

    final PyObject array___imul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        this.resizeCheck();
        if (this.delegate.getSize() > 0) {
            int count2 = o.asIndex(Py.OverflowError);
            if (count2 <= 0) {
                this.delegate.clear();
                return this;
            }
            Object copy = this.delegate.copyArray();
            this.delegate.ensureCapacity(this.delegate.getSize() * count2);
            for (int i = 1; i < count2; ++i) {
                this.delegate.appendArray(copy);
            }
        }
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.array___mul__(o);
    }

    final PyObject array___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.array___rmul__(o);
    }

    final PyObject array___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iadd__(PyObject other) {
        return this.array___iadd__(other);
    }

    final PyObject array___iadd__(PyObject other) {
        try {
            PyArray otherArr = this.arrayChecked(other);
            this.resizeCheck();
            this.delegate.appendArray(otherArr.delegate.copyArray());
            return this;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.array___add__(other);
    }

    final PyObject array___add__(PyObject other) {
        try {
            PyArray otherArr = this.arrayChecked(other);
            PyArray ret = new PyArray(this);
            ret.delegate.appendArray(otherArr.delegate.copyArray());
            return ret;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private PyArray arrayChecked(PyObject otherObject) throws ClassCastException {
        PyArray other = (PyArray)otherObject;
        if (this.itemType == other.itemType) {
            if (this.itemType != ItemType.OBJECT) {
                return other;
            }
            if (this.itemClass.isAssignableFrom(other.itemClass)) {
                return other;
            }
        }
        throw Py.TypeError(String.format("bad argument types for built-in operation: (%s, %s)", this.reprTypecode(), other.reprTypecode()));
    }

    @Override
    public int __len__() {
        return this.array___len__();
    }

    final int array___len__() {
        return this.delegate.getSize();
    }

    @Override
    public PyObject __reduce__() {
        return this.array___reduce__();
    }

    final PyObject array___reduce__() {
        PyObject dict = this.__findattr__("__dict__");
        if (dict == null) {
            dict = Py.None;
        }
        PyString typecode = Py.newString(this.getTypecode());
        if (this.__len__() > 0) {
            return new PyTuple(this.getType(), new PyTuple(typecode, Py.newString(this.tostring())), dict);
        }
        return new PyTuple(this.getType(), new PyTuple(typecode), dict);
    }

    @Override
    public String toString() {
        String value;
        if (this.__len__() == 0) {
            return String.format("array(%s)", this.reprTypecode());
        }
        switch (this.itemType) {
            case CHAR: {
                value = PyString.encode_UnicodeEscape(this.tostring(), true);
                break;
            }
            case UNICHAR: {
                value = new PyUnicode(this.tounicode()).__repr__().toString();
                break;
            }
            default: {
                value = this.tolist().toString();
            }
        }
        return String.format("array(%s, %s)", this.reprTypecode(), value);
    }

    private String reprTypecode() {
        if (this.itemType == ItemType.OBJECT) {
            return this.getTypecode();
        }
        return "'" + this.getTypecode() + "'";
    }

    @Override
    public Object __tojava__(Class<?> c) {
        boolean isArray = c.isArray();
        Class<?> componentType = c.getComponentType();
        if (c == Object.class || isArray && componentType.isAssignableFrom(this.itemClass)) {
            if (this.delegate.capacity != this.delegate.size) {
                return this.delegate.copyArray();
            }
            return this.data;
        }
        if (isArray && componentType == Object.class) {
            Object[] boxed = new Object[this.delegate.size];
            for (int i = 0; i < this.delegate.size; ++i) {
                boxed[i] = Array.get(this.data, i);
            }
            return boxed;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public final void array_append(PyObject value) {
        this.resizeCheck();
        this.appendUnchecked(value);
    }

    public void append(PyObject value) {
        this.resizeCheck();
        this.appendUnchecked(value);
    }

    private final void appendUnchecked(PyObject value) {
        int afterLast = this.delegate.getSize();
        this.delegate.makeInsertSpace(afterLast);
        try {
            this.pyset(afterLast, value);
        }
        catch (PyException e) {
            this.delegate.setSize(afterLast);
            throw new PyException(e.type, e.value);
        }
    }

    public void array_byteswap() {
        this.byteswap();
    }

    public void byteswap() {
        if (this.itemType == ItemType.OBJECT) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class<?> char2class(char typecode) throws PyIgnoreMethodTag {
        return ItemType.fromTypecode((char)typecode).itemClass;
    }

    public final int array_count(PyObject value) {
        int iCount = 0;
        int len = this.delegate.getSize();
        for (int i = 0; i < len; ++i) {
            if (!value.equals(this.itemType.get(this, i))) continue;
            ++iCount;
        }
        return iCount;
    }

    public PyInteger count(PyObject value) {
        return Py.newInteger(this.array_count(value));
    }

    @Override
    protected void del(int i) {
        this.resizeCheck();
        this.delegate.remove(i);
    }

    @Override
    protected void delRange(int start, int stop) {
        this.resizeCheck();
        this.delegate.remove(start, stop);
    }

    public final void array_extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    public void extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void extendInternal(PyObject iterable) {
        if (iterable instanceof PyUnicode) {
            if (this.itemType == ItemType.UNICHAR) {
                this.extendUnicodeIter(iterable);
                return;
            }
            if (this.itemType != ItemType.CHAR) throw Py.TypeError("an integer is required");
            throw Py.TypeError("array item must be char");
        }
        if (iterable instanceof PyArray) {
            PyArray source = (PyArray)iterable;
            if (source.itemType != this.itemType) throw Py.TypeError("can only extend with array of same kind");
            this.resizeCheck();
            this.delegate.appendArray(source.delegate.copyArray());
            return;
        }
        this.extendInternalIter(iterable);
    }

    private void extendInternalIter(PyObject iterable) {
        this.resizeCheck();
        if (iterable.__findattr__("__len__") != null) {
            int last = this.delegate.getSize();
            this.delegate.ensureCapacity(last + iterable.__len__());
            for (PyObject item : iterable.asIterable()) {
                this.pyset(last++, item);
                ++this.delegate.size;
            }
        } else {
            for (PyObject item : iterable.asIterable()) {
                this.appendUnchecked(item);
            }
        }
    }

    private void extendUnicodeIter(PyObject iterable) {
        this.resizeCheck();
        try {
            for (PyObject item : iterable.asIterable()) {
                PyUnicode uitem = (PyUnicode)item;
                for (int codepoint : uitem.toCodePoints()) {
                    int afterLast = this.delegate.getSize();
                    this.delegate.makeInsertSpace(afterLast);
                    Array.setInt(this.data, afterLast, codepoint);
                }
            }
        }
        catch (ClassCastException e) {
            throw this.notCompatibleTypeError();
        }
    }

    private void extendArray(PyUnicode codepoints) {
        this.resizeCheck();
        int last = this.delegate.getSize();
        int[] items = codepoints.toCodePoints();
        this.delegate.ensureCapacity(last + items.length);
        for (int item : items) {
            Array.setInt(this.data, last++, item);
            ++this.delegate.size;
        }
    }

    public final void array_fromfile(PyObject f, int count2) {
        this.fromfile(f, count2);
    }

    public void fromfile(PyObject f, int count2) {
        this.resizeCheck();
        if (f instanceof PyFile) {
            PyFile file = (PyFile)f;
            if (!file.getClosed()) {
                int readbytes = count2 * this.itemType.itemsize;
                String buffer = file.read(readbytes).toString();
                this.fromstring(buffer);
                if (buffer.length() < readbytes) {
                    int readcount = buffer.length() / this.itemType.itemsize;
                    throw Py.EOFError(String.format(NOT_ENOUGH_IN_FILE, count2, readcount));
                }
            }
            return;
        }
        throw Py.TypeError("arg1 must be open file");
    }

    public final void array_fromlist(PyObject obj) {
        this.fromlist(obj);
    }

    public void fromlist(PyObject obj) {
        if (!(obj instanceof PyList)) {
            throw Py.TypeError("arg must be list");
        }
        int size = this.delegate.getSize();
        try {
            this.extendInternalIter(obj);
        }
        catch (PyException e) {
            this.delegate.setSize(size);
            throw new PyException(e.type, e.value);
        }
    }

    public int fillFromStream(InputStream is) throws IOException {
        return this.fromStream(is, 0, this.delegate.getSize());
    }

    private int fromStream(InputStream is, int start, int count2) throws IOException {
        int limit = start + count2;
        int size = this.delegate.getSize();
        if (limit > size) {
            this.resizeCheck();
            this.delegate.setSize(limit);
        }
        DataInputStream dis = new DataInputStream(is);
        return this.itemType.fromStream(dis, this.data, start, limit) - start;
    }

    public void fromstring(PyObject input) {
        this.array_fromstring(input);
    }

    public void fromstring(String input) {
        this.fromBytes(this.delegate.getSize(), StringUtil.toBytes(input));
    }

    public int fromstring(int start, String input) {
        return this.fromBytes(start, StringUtil.toBytes(input));
    }

    final void array_fromstring(PyObject input) {
        int start = this.delegate.getSize();
        if (input instanceof BufferProtocol) {
            if (input instanceof PyUnicode) {
                String s = ((PyUnicode)input).encode();
                this.fromBytes(start, StringUtil.toBytes(s));
            } else {
                try (PyBuffer pybuf = ((BufferProtocol)((Object)input)).getBuffer(24);){
                    if (pybuf.getNdim() == 1) {
                        if (pybuf.getStrides()[0] == 1) {
                            this.fromBytes(start, pybuf.getNIOByteBuffer());
                        }
                        byte[] copy = new byte[pybuf.getLen()];
                        pybuf.copyTo(copy, 0);
                        this.fromBytes(start, ByteBuffer.wrap(copy));
                    }
                    throw Py.ValueError("multi-dimensional buffer not supported");
                }
            }
        } else {
            String fmt = "must be string or read-only buffer, not %s";
            throw Py.TypeError(String.format(fmt, input.getType().fastGetName()));
        }
    }

    private final int fromBytes(int start, byte[] bytes) {
        return this.fromBytes(start, ByteBuffer.wrap(bytes));
    }

    private final int fromBytes(int start, ByteBuffer bytes) {
        int count2;
        int byteCount = bytes.remaining();
        if (byteCount > (count2 = byteCount / this.itemType.itemsize) * this.itemType.itemsize) {
            throw Py.ValueError("data length not a multiple of item size");
        }
        try {
            ByteBufferBackedInputStream is = new ByteBufferBackedInputStream(bytes);
            return this.fromStream(is, start, count2);
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public void fromunicode(PyUnicode input) {
        this.array_fromunicode(input);
    }

    final void array_fromunicode(PyObject input) {
        if (!(input instanceof PyUnicode)) {
            throw Py.ValueError("fromunicode argument must be an unicode object");
        }
        if (this.itemType != ItemType.UNICHAR) {
            throw Py.ValueError("fromunicode() may only be called on type 'u' arrays");
        }
        this.extend(input);
    }

    @Override
    protected PyObject pyget(int i) {
        return this.itemType.get(this, i);
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        return this.itemType.itemsize;
    }

    @Deprecated
    public int getStorageSize() {
        return this.itemType.itemsize;
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyArray.sliceLength(start, stop, step);
        PyArray ret = new PyArray(TYPE, this.itemType, this.itemClass, n);
        if (step == 1) {
            System.arraycopy(this.data, start, ret.data, 0, n);
            return ret;
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            Array.set(ret.data, j, Array.get(this.data, i));
            i += step;
        }
        return ret;
    }

    private CharSequence description() {
        if (this.itemType == ItemType.OBJECT) {
            return this.itemClass.getName();
        }
        return this.itemType.description();
    }

    public String getTypecode() {
        if (this.itemType == ItemType.OBJECT) {
            return this.itemClass.getName();
        }
        return this.itemType.typecode;
    }

    public final int array_index(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            return index;
        }
        throw Py.ValueError("array.index(" + value + "): " + value + " not found in array");
    }

    public PyObject index(PyObject value) {
        return Py.newInteger(this.array_index(value));
    }

    private int indexInternal(PyObject value) {
        int len = this.delegate.getSize();
        for (int i = 0; i < len; ++i) {
            if (!value.equals(this.pyget(i))) continue;
            return i;
        }
        return -1;
    }

    public final void array_insert(int index, PyObject value) {
        this.insert(index, value);
    }

    public void insert(int index, PyObject value) {
        this.resizeCheck();
        index = this.boundToSequence(index);
        this.delegate.makeInsertSpace(index);
        this.pyset(index, value);
    }

    public final PyObject array_pop(int i) {
        return this.pop(i);
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int index) {
        if (this.delegate.getSize() == 0) {
            throw Py.IndexError("pop from empty array");
        }
        if ((index = this.delegator.fixindex(index)) == -1) {
            throw Py.IndexError("pop index out of range");
        }
        this.resizeCheck();
        PyObject ret = this.itemType.get(this, index);
        this.delegate.remove(index);
        return ret;
    }

    public final void array_remove(PyObject value) {
        this.remove(value);
    }

    public void remove(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            this.resizeCheck();
            this.delegate.remove(index);
            return;
        }
        throw Py.ValueError("array.remove(" + value + "): " + value + " not found in array");
    }

    @Override
    protected PyObject repeat(int count2) {
        Object arraycopy = this.delegate.copyArray();
        PyArray ret = new PyArray(this.itemClass, 0);
        ret.setElementType(this.itemType, this.itemClass);
        for (int i = 0; i < count2; ++i) {
            ret.delegate.appendArray(arraycopy);
        }
        return ret;
    }

    public final void array_reverse() {
        this.reverse();
    }

    public void reverse() {
        Object array = Array.newInstance(this.itemClass, Array.getLength(this.data));
        int lastIndex = this.delegate.getSize() - 1;
        for (int i = 0; i <= lastIndex; ++i) {
            Array.set(array, lastIndex - i, Array.get(this.data, i));
        }
        this.data = array;
    }

    public void set(int i, PyObject value) {
        this.pyset(i, value);
    }

    @Override
    protected void pyset(int i, PyObject value) {
        try {
            this.itemType.set(this, i, value);
        }
        catch (ClassCastException cce) {
            throw Py.TypeError(String.format("array item must be %s", this.description()));
        }
    }

    public void set(int i, int value) {
        if (this.itemType != ItemType.UNICHAR && this.itemClass != Integer.TYPE && this.itemClass != Long.TYPE) {
            throw this.notCompatibleTypeError();
        }
        Array.setInt(this.data, i, value);
    }

    public void set(int i, char value) {
        if (this.itemType != ItemType.CHAR && this.itemClass != Integer.TYPE && this.itemClass != Long.TYPE) {
            throw this.notCompatibleTypeError();
        }
        Array.setChar(this.data, i, value);
    }

    public void set(int i, byte value) {
        if (this.itemClass != Byte.TYPE) {
            throw this.notCompatibleTypeError();
        }
        Array.setByte(this.data, i, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (this.itemClass == Character.TYPE && value instanceof PyString) {
            char[] chars = null;
            if (step != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            chars = value.toString().toCharArray();
            if (start + chars.length != stop) {
                this.resizeCheck();
            }
            this.delegate.replaceSubArray(start, stop, chars, 0, chars.length);
            return;
        } else if (value instanceof PyString && this.itemClass == Byte.TYPE) {
            byte[] chars = ((PyString)value).toBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        } else {
            if (!(value instanceof PyArray)) throw Py.TypeError(String.format("can only assign array (not \"%.200s\") to array slice", value.getType().fastGetName()));
            PyArray array = this.arrayChecked(value);
            if (step == 1) {
                Object arrayDelegate = array == this ? array.delegate.copyArray() : array.delegate.getArray();
                int len = array.delegate.getSize();
                if (start + len != stop) {
                    this.resizeCheck();
                }
                try {
                    this.delegate.replaceSubArray(start, stop, arrayDelegate, 0, len);
                    return;
                }
                catch (IllegalArgumentException e) {
                    throw Py.TypeError("Slice typecode " + array.reprTypecode() + " is not compatible with this array (typecode " + this.reprTypecode() + ")");
                }
            } else if (step > 1) {
                int len = array.__len__();
                int i = 0;
                int j = 0;
                while (i < len) {
                    Array.set(this.data, j + start, Array.get(array.data, i));
                    ++i;
                    j += step;
                }
                return;
            } else {
                if (step >= 0) return;
                if (array == this) {
                    array = (PyArray)array.clone();
                }
                int len = array.__len__();
                int i = 0;
                int j = start;
                while (i < len) {
                    Array.set(this.data, j, Array.get(array.data, i));
                    ++i;
                    j += step;
                }
            }
        }
    }

    public final void array_tofile(PyObject f) {
        this.tofile(f);
    }

    public void array_write(PyObject f) {
        this.tofile(f);
    }

    public void tofile(PyObject f) {
        if (!(f instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile file = (PyFile)f;
        file.write(this.tostring());
    }

    public final PyObject array_tolist() {
        return this.tolist();
    }

    public PyObject tolist() {
        PyList list = new PyList();
        int len = this.delegate.getSize();
        for (int i = 0; i < len; ++i) {
            list.append(this.itemType.get(this, i));
        }
        return list;
    }

    public int toStream(OutputStream os2) throws IOException {
        DataOutputStream dos = new DataOutputStream(os2);
        this.itemType.toStream(dos, this.data, this.delegate.getSize());
        return dos.size();
    }

    public final PyObject array_tostring() {
        return new PyString(this.tostring());
    }

    public String tostring() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.toStream(bos);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return StringUtil.fromBytes(bos.toByteArray());
    }

    public final PyUnicode array_tounicode() {
        if (this.itemType != ItemType.UNICHAR) {
            throw Py.ValueError("tounicode() may only be called on type 'u' arrays");
        }
        int len = this.delegate.getSize();
        int[] codepoints = new int[len];
        for (int i = 0; i < len; ++i) {
            codepoints[i] = Array.getInt(this.data, i);
        }
        return new PyUnicode(codepoints);
    }

    public String tounicode() {
        return this.array_tounicode().getString();
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        if ((flags & 0xFFFFFFFE) == 0) {
            BaseBuffer pybuf = this.getExistingBuffer(flags);
            if (pybuf == null) {
                if (this.itemClass == Byte.TYPE) {
                    byte[] storage = (byte[])this.data;
                    int size = this.delegate.getSize();
                    pybuf = new SimpleBuffer(flags, this, storage, 0, size);
                } else {
                    pybuf = new SimpleStringBuffer(flags, (BufferProtocol)this, this.tostring());
                }
                this.export = new WeakReference<BaseBuffer>(pybuf);
            }
            return pybuf;
        }
        throw new ClassCastException("'array' supports only a byte-buffer view");
    }

    private BaseBuffer getExistingBuffer(int flags) throws PyException {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = (BaseBuffer)this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    private void resizeCheck() throws PyException {
        if (this.export != null) {
            PyBuffer pybuf = (PyBuffer)this.export.get();
            if (pybuf != null && !pybuf.isReleased()) {
                throw Py.BufferError("cannot resize an array that is exporting buffers");
            }
            this.export = null;
        }
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        if (this.data == null || !gc.canLinkToPyObject(this.data.getClass(), true)) {
            return 0;
        }
        return gc.traverseByReflection(this.data, visit, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) throws UnsupportedOperationException {
        if (this.data == null || !gc.canLinkToPyObject(this.data.getClass(), true)) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    PyException notCompatibleTypeError() {
        return Py.TypeError(String.format("Type not compatible with array of '%s'", this.description()));
    }

    static {
        PyType.addBuilder(PyArray.class, new PyArray$PyExposer());
        TYPE = PyType.fromClass(PyArray.class);
    }

    static enum ItemType {
        BYTE("b", "byte", (Class)Byte.TYPE, 1, -128L, 127L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setByte(a.data, i, (byte)this.checkedInteger(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.newInteger(Array.getByte(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeByte(Array.getByte(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        byte val = dis.readByte();
                        Array.setByte(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        UBYTE("B", "byte", (Class)Byte.TYPE, 1, 255L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setByte(a.data, i, (byte)this.checkedInteger(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.newInteger(0xFF & Array.getByte(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeByte(Array.getByte(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        byte val = dis.readByte();
                        Array.setByte(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        SHORT("h", "short integer", (Class)Short.TYPE, 2, -32768L, 32767L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setShort(a.data, i, (short)this.checkedInteger(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.newInteger(Array.getShort(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeShort(Array.getShort(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        short val = dis.readShort();
                        Array.setShort(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        USHORT("H", "short integer", (Class)Short.TYPE, 2, 65535L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setShort(a.data, i, (short)this.checkedInteger(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.newInteger(0xFFFF & Array.getShort(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeShort(Array.getShort(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        short val = dis.readShort();
                        Array.setShort(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        INT("i", "int", (Class)Integer.TYPE, 4, Integer.MIN_VALUE, Integer.MAX_VALUE){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setInt(a.data, i, (int)this.checkedInteger(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.newInteger(Array.getInt(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeInt(Array.getInt(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        int val = dis.readInt();
                        Array.setInt(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        UINT("I", "int", (Class)Integer.TYPE, 4, 0xFFFFFFFFL){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setInt(a.data, i, (int)this.checkedInteger(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                int val = Array.getInt(a.data, i);
                if (val >= 0) {
                    return Py.newInteger(val);
                }
                return new PyLong(0xFFFFFFFFL & (long)val);
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeInt(Array.getInt(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        int val = dis.readInt();
                        Array.setInt(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        LONG("l", "long", (Class)Long.TYPE, 8, Long.MIN_VALUE, Long.MAX_VALUE){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setLong(a.data, i, this.checkedSignedLong(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return new PyLong(Array.getLong(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeLong(Array.getLong(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        long val = dis.readLong();
                        Array.setLong(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        ULONG("L", "long", (Class)Long.TYPE, 8, -1L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setLong(a.data, i, this.checkedUnsignedLong(value));
            }

            @Override
            PyObject get(PyArray a, int i) {
                long val = Array.getLong(a.data, i);
                if (val >= 0L) {
                    return new PyLong(val);
                }
                return new PyLong(BigInteger.valueOf(val).add(TWO_TO_64));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeLong(Array.getLong(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        long val = dis.readLong();
                        Array.setLong(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        FLOAT("f", "float", (Class)Float.TYPE, 4){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setFloat(a.data, i, (float)value.asDouble());
            }

            @Override
            PyObject get(PyArray a, int i) {
                return new PyFloat(Array.getFloat(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeFloat(Array.getFloat(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        float val = dis.readFloat();
                        Array.setFloat(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        DOUBLE("d", "double", (Class)Double.TYPE, 8){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setDouble(a.data, i, value.asDouble());
            }

            @Override
            PyObject get(PyArray a, int i) {
                return new PyFloat(Array.getDouble(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeDouble(Array.getDouble(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        double val = dis.readDouble();
                        Array.setDouble(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        CHAR("c", "char", (Class)Byte.TYPE, 1, 255L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                String s = ((PyString)value).getString();
                if (s.length() != 1) {
                    throw new ClassCastException();
                }
                Array.setByte(a.data, i, (byte)s.charAt(0));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.makeCharacter((char)(0xFF & Array.getByte(a.data, i)));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeByte(Array.getByte(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        byte val = dis.readByte();
                        Array.setByte(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        UNICHAR("u", "unicode character", (Class)Integer.TYPE, 4, 0x10FFFFL){

            @Override
            void set(PyArray a, int i, PyObject value) {
                String s = ((PyUnicode)value).getString();
                if (s.codePointCount(0, Math.min(s.length(), 4)) != 1) {
                    throw new ClassCastException();
                }
                Array.setInt(a.data, i, s.codePointAt(0));
            }

            @Override
            PyObject get(PyArray a, int i) {
                return new PyUnicode(Array.getInt(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeInt(Array.getInt(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        int val = dis.readInt();
                        Array.setInt(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        BOOLEAN("z", "boolean", (Class)Boolean.TYPE, 1, 0L){

            @Override
            void set(PyArray a, int i, PyObject value) {
                Array.setBoolean(a.data, i, value.__nonzero__());
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.newBoolean(Array.getBoolean(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
                for (int i = 0; i < n; ++i) {
                    dos.writeBoolean(Array.getBoolean(data, i));
                }
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                try {
                    while (index < limit) {
                        boolean val = dis.readBoolean();
                        Array.setBoolean(data, index++, val);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                return index;
            }
        }
        ,
        OBJECT{

            @Override
            void set(PyArray a, int i, PyObject value) {
                Object val = value.__tojava__(a.itemClass);
                if (val == Py.NoConversion) {
                    throw a.notCompatibleTypeError();
                }
                Array.set(a.data, i, val);
            }

            @Override
            PyObject get(PyArray a, int i) {
                return Py.java2py(Array.get(a.data, i));
            }

            @Override
            void toStream(DataOutputStream dos, Object data, int n) throws IOException {
            }

            @Override
            int fromStream(DataInputStream dis, Object data, int index, int limit) throws IOException {
                return index;
            }
        };

        String typecode;
        final String description;
        Class<?> itemClass;
        int itemsize;
        long min;
        long max;
        protected static final BigInteger TWO_TO_64;

        abstract void set(PyArray var1, int var2, PyObject var3);

        abstract PyObject get(PyArray var1, int var2);

        abstract void toStream(DataOutputStream var1, Object var2, int var3) throws IOException;

        abstract int fromStream(DataInputStream var1, Object var2, int var3, int var4) throws IOException;

        private ItemType(String typecode, String description, Class<?> itemClass, int itemsize, long min, long max) {
            this.typecode = typecode;
            this.description = description;
            this.itemClass = itemClass;
            this.itemsize = itemsize;
            this.min = min;
            this.max = max;
        }

        private ItemType(String typecode, String description, Class<?> itemClass, int itemsize) {
            this(typecode, description, itemClass, itemsize, 0L, 0L);
        }

        private ItemType(String typecode, String description, Class<?> itemClass, int itemsize, long max) {
            this(typecode, description, itemClass, itemsize, 0L, max);
        }

        private ItemType() {
            this("", "Java Object", Object.class, 0, 0L, 0L);
        }

        static ItemType fromTypecode(char typecode) {
            switch (typecode) {
                case 'z': {
                    return BOOLEAN;
                }
                case 'b': {
                    return BYTE;
                }
                case 'B': {
                    return UBYTE;
                }
                case 'u': {
                    return UNICHAR;
                }
                case 'c': {
                    return CHAR;
                }
                case 'h': {
                    return SHORT;
                }
                case 'H': {
                    return USHORT;
                }
                case 'i': {
                    return INT;
                }
                case 'I': {
                    return UINT;
                }
                case 'l': {
                    return LONG;
                }
                case 'L': {
                    return ULONG;
                }
                case 'f': {
                    return FLOAT;
                }
                case 'd': {
                    return DOUBLE;
                }
            }
            throw Py.ValueError("typecode must be " + ItemType.reminder());
        }

        static ItemType fromJavaClass(Class<?> cls) {
            for (ItemType i : ItemType.values()) {
                if (!cls.equals(i.itemClass)) continue;
                return i;
            }
            return OBJECT;
        }

        protected long checkedInteger(PyObject value) {
            long val;
            if (this.min == 0L) {
                val = this.checkedUnsignedLong(value);
            } else {
                val = this.checkedSignedLong(value);
                if (val < this.min) {
                    throw this.lessThanMinimum();
                }
            }
            if (val > this.max) {
                throw this.moreThanMaximum();
            }
            return val;
        }

        protected long checkedSignedLong(PyObject value) throws PyException, ClassCastException {
            if (value instanceof PyInteger) {
                return ((PyInteger)value).getValue();
            }
            if (value instanceof PyLong) {
                BigInteger val = ((PyLong)value).getValue();
                if (PyLong.MAX_LONG.compareTo(val) < 0) {
                    throw this.moreThanMaximum();
                }
                if (PyLong.MIN_LONG.compareTo(val) > 0) {
                    throw this.lessThanMinimum();
                }
                return val.longValue();
            }
            Long val = (Long)value.__tojava__(Long.TYPE);
            if (val == null) {
                throw new ClassCastException();
            }
            return val;
        }

        protected long checkedUnsignedLong(PyObject value) throws ClassCastException {
            BigInteger val;
            if (value instanceof PyInteger) {
                int val2 = ((PyInteger)value).getValue();
                if (val2 < 0) {
                    throw this.lessThanMinimum();
                }
                return val2;
            }
            if (value instanceof PyLong) {
                val = ((PyLong)value).getValue();
            } else {
                val = (BigInteger)value.__tojava__(BigInteger.class);
                if (val == null) {
                    throw new ClassCastException();
                }
            }
            if (BigInteger.ZERO.compareTo(val) > 0) {
                throw this.lessThanMinimum();
            }
            if (PyLong.MAX_ULONG.compareTo(val) < 0) {
                throw this.moreThanMaximum();
            }
            if (PyLong.MAX_LONG.compareTo(val) < 0) {
                return val.subtract(TWO_TO_64).longValue();
            }
            return val.longValue();
        }

        CharSequence description() {
            StringBuilder buf = new StringBuilder(this.description.length() + 10);
            switch (this) {
                case CHAR: 
                case UNICHAR: 
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case OBJECT: {
                    break;
                }
                default: {
                    buf.append(this.min < 0L ? "signed " : "unsigned ");
                }
            }
            buf.append(this.description);
            return buf;
        }

        private static CharSequence reminder() {
            StringBuilder buf = new StringBuilder(100);
            for (ItemType i : ItemType.values()) {
                if (i == OBJECT) continue;
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(i.typecode);
            }
            buf.append(" or a Java class");
            return buf;
        }

        protected PyException lessThanMinimum() {
            return Py.OverflowError(String.format("%s array value is less than minimum", this.description()));
        }

        protected PyException moreThanMaximum() {
            return Py.OverflowError(String.format("%s array value is more than maximum", this.description()));
        }

        static {
            TWO_TO_64 = BigInteger.ONE.shiftLeft(64);
        }
    }

    private class ArrayDelegate
    extends AbstractArray {
        private ArrayDelegate() {
            super(PyArray.this.data == null ? 0 : Array.getLength(PyArray.this.data));
        }

        @Override
        protected Object getArray() {
            return PyArray.this.data;
        }

        @Override
        protected void setArray(Object array) {
            PyArray.this.data = array;
        }

        @Override
        protected Object createArray(int size) {
            Class<?> baseType = PyArray.this.data.getClass().getComponentType();
            return Array.newInstance(baseType, size);
        }
    }

    private class ByteBufferBackedInputStream
    extends InputStream {
        ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf;
        }

        @Override
        public int available() throws IOException {
            return this.buf.remaining();
        }

        @Override
        public int read() {
            return this.buf.hasRemaining() ? this.buf.get() & 0xFF : -1;
        }

        @Override
        public int read(byte[] bytes, int off, int len) {
            int n = this.buf.remaining();
            if (n >= len) {
                this.buf.get(bytes, off, len);
                return len;
            }
            if (n > 0) {
                this.buf.get(bytes, off, n);
                return n;
            }
            return -1;
        }
    }
}

